/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.fulltext;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.NotifyCache;
import kd.bos.dts.impl.fulltext.EsMapperFactory;
import kd.bos.dts.impl.fulltext.FullTextMatchProperties;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.impl.fulltext.access.ESAccess;
import kd.bos.dts.init.AbstractInitialize;
import kd.bos.dts.multientity.MultiEntity;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.fulltext.MatchProperty;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESInitialize
extends AbstractInitialize {
    private Mapper mapper;
    private MultiEntity mulEntity = null;
    private static final Logger logger = LoggerFactory.getLogger(ESInitialize.class);

    public ESInitialize(DestinationTransRule destinationRule) {
        super(destinationRule);
        this.mapper = EsMapperFactory.getMapper(destinationRule.getMappingrule(), destinationRule.getRegion());
        this.mulEntity = this.mapper.getMultiEntity();
    }

    @Override
    protected int getBatchSize() {
        return Integer.getInteger("dts.fulltext.init.batchsize", 1000);
    }

    @Override
    public void doTransmitData(List<RowInfo> esconsumers) {
        if (esconsumers.isEmpty()) {
            return;
        }
        String tableName = esconsumers.get(0).getTable();
        if (!this.mapper.checkTable(tableName)) {
            return;
        }
        String indexName = this.mapper.getIndexName(tableName);
        ESAccess.get(this.region).applyRows(indexName, esconsumers, this.mapper.getESDataType(), this.mapper);
    }

    @Override
    public void initCreateEntityMeta(SyncConfigInfo scinfo) {
        List<MatchProperty> match = this.getMatchProperties(scinfo, null);
        this.mapper.initCreateEntityMeta(scinfo.getEntitynumber(), match);
        NotifyCache.get().remove("fulltext_metaconfig_needRefresh");
        logger.info("initCreateEntityMeta sucess:" + scinfo);
    }

    @Override
    protected void deleteEntityFileds(SyncConfigCompareInfo compare, String deleteFileds) {
        List<MatchProperty> match = this.getMatchProperties(compare, deleteFileds);
        this.mapper.deleteEntityFileds(compare.getEntitynumber(), match);
        NotifyCache.get().remove("fulltext_metaconfig_needRefresh");
    }

    @Override
    public void deleteEntity(SyncConfigInfo compare) {
        this.mapper.deleteEntity(compare.getEntitynumber());
        NotifyCache.get().remove("fulltext_metaconfig_needRefresh");
    }

    private List<MatchProperty> getMatchProperties(SyncConfigInfo scinfo, String specFieldsStr) {
        String entityNumber = scinfo.getEntitynumber();
        String filedsStr = scinfo.getConfiggedEntityfields();
        if (specFieldsStr != null) {
            filedsStr = specFieldsStr;
        }
        HashSet<String> properties = null;
        if (filedsStr != null && filedsStr.trim().length() > 0 && filedsStr.indexOf("*") < 0) {
            String[] fileds;
            properties = new HashSet<String>(2);
            for (String filed : fileds = filedsStr.split(",")) {
                properties.add(filed);
            }
        }
        ArrayList<String> dynFieldReturn = new ArrayList<String>();
        List<MatchProperty> matchProperties = FullTextMatchProperties.getMatchProperties(dynFieldReturn, entityNumber, properties, filedsStr, specFieldsStr);
        dynFieldReturn.forEach(v -> scinfo.addDynFiled((String)v));
        return matchProperties;
    }

    @Override
    public boolean isSkip(SyncConfigInfo compare) {
        if (this.mulEntity == null) {
            return false;
        }
        return !this.mulEntity.isMainEntity(compare.getEntitynumber());
    }

    @Override
    public void notifyEndInit(OperationType opType, String entityNumber) {
        this.mapper.endInit(opType.getName(), entityNumber);
    }
}

