/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.fulltext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.FieldUtils;
import kd.bos.dts.es.Mapping;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.impl.fulltext.mapping.ESFullTextMapper;
import kd.bos.dts.impl.fulltext.mapping.WrapMapper;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.util.ExceptionUtils;

public class EsMapperFactory {
    private static ConcurrentHashMap<String, Mapper> poolMap = new ConcurrentHashMap();
    private static ExtensionFactory<Mapper> factory = ExtensionFactory.getExtensionFacotry(Mapper.class);
    private static ExtensionFactory<Mapping> factorynew = ExtensionFactory.getExtensionFacotry(Mapping.class);

    public static Mapper getMapper(String mappingRule, String region) {
        String key = RequestContext.get().getAccountId() + mappingRule + region;
        return poolMap.computeIfAbsent(key, x -> {
            if (mappingRule == null || mappingRule.trim().length() == 0) {
                return new ESFullTextMapper(region);
            }
            Map<String, Map<String, String>> rMap = DtsUtils.parseMappingRule(mappingRule);
            Mapper mapper = null;
            for (Map.Entry<String, Map<String, String>> entryset : rMap.entrySet()) {
                mapper = EsMapperFactory.getMapperExtension(entryset.getKey(), region);
                EsMapperFactory.setProperties(mapper, entryset.getValue());
            }
            return mapper;
        });
    }

    private static void setProperties(Mapper mapper, Map<String, String> value) {
        for (Map.Entry<String, String> entryset : value.entrySet()) {
            FieldUtils.setFiledValue(entryset.getKey(), mapper, entryset.getValue());
        }
    }

    private static Mapper getMapperExtension(String mappingRule, String region) {
        Mapping mapping;
        Mapper mapper = null;
        try {
            mapper = (Mapper)factory.getExtension(mappingRule, false);
        }
        catch (Exception e) {
            ExceptionUtils.parseException((Throwable)e);
        }
        if (mapper == null && (mapping = (Mapping)factorynew.getExtension(mappingRule, false)) != null) {
            mapper = mapping instanceof Mapper ? (Mapper)mapping : new WrapMapper(mapping);
        }
        if (mapper == null) {
            throw new KDException(DtsErrorCode.unsupport, new Object[]{"unsupport EsTransmitter`s mappingRule type:" + mappingRule});
        }
        mapper.setRegion(region);
        return mapper;
    }
}

