/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.fulltext.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dts.RowInfo;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.impl.fulltext.mapping.CommonUtils;
import kd.bos.dts.impl.fulltext.mapping.EsConfigMonitor;
import kd.bos.dts.impl.fulltext.mapping.FieldMeta;
import kd.bos.dts.impl.fulltext.mapping.TableMeta;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.fulltext.MatchProperty;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.common.util.PinYinUtil;
import kd.bos.fulltext.impl.FullTextUpdaterImpl;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class ESFullTextMapper
implements Mapper {
    public static final String FULLTEXT_DATA_TYPE = "t_data";
    private static final int PYMAXSTRING = Integer.parseInt(System.getProperty("dts.fulltext.py.maxtranssize", "10"));
    protected String region;

    public ESFullTextMapper() {
    }

    public ESFullTextMapper(String region) {
        if (region == null || region.length() == 0) {
            region = "quicksearch";
        }
        this.region = region;
        EsConfigMonitor.get(region).init();
    }

    public Map<?, ?> convert2Es(String tableName, RowInfo row) {
        TableMeta tableMeta = EsConfigMonitor.get(this.region).getTableMeta(tableName, row.getEntityNumber());
        return this._convert2Es(tableMeta, row);
    }

    public String getKeyId(RowInfo row) {
        String table = row.getTable();
        TableMeta tableMeta = EsConfigMonitor.get(this.region).getTableMeta(table, row.getEntityNumber());
        String id = CommonUtils.getIdByEntityNamePkId(tableMeta.getEntityName(), row.getKey());
        return id;
    }

    private Map<String, Object> _convert2Es(TableMeta tableMeta, RowInfo row) {
        Map data = row.getData();
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<FieldValue> fvList = new ArrayList<FieldValue>();
        String pkId = row.getKey();
        FieldValue fvPkId = new FieldValue("pkid", (Object)String.valueOf(pkId));
        fvList.add(fvPkId);
        FieldValue fvEntityName = new FieldValue("entityname", (Object)tableMeta.getEntityName());
        fvList.add(fvEntityName);
        FieldMeta[] fields = tableMeta.getFields();
        if (tableMeta.isMultLangTable()) {
            String lang = (String)data.get("flocaleid");
            for (FieldMeta field : fields) {
                String filedName = field.getFiledName().toLowerCase();
                if (!data.containsKey(filedName)) continue;
                FieldValue fvFieldName = new FieldValue(CommonUtils.getLangPN(field.getPropertyName(), lang) + "_" + field.getDatatype(), data.get(filedName));
                fvList.add(fvFieldName);
                if (!field.isPy() || !"zh_CN".equalsIgnoreCase(lang)) continue;
                Object pyValue = data.get(filedName);
                try {
                    pyValue = this.getPYValue(pyValue + "");
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    ExceptionLogger.error(ESFullTextMapper.class, (String)"trans py error ", (Throwable)e);
                }
                FieldValue fvFieldNamePY = new FieldValue(CommonUtils.getPinyinPN(field.getPropertyName()) + "_" + field.getDatatype(), pyValue);
                fvList.add(fvFieldNamePY);
            }
        } else {
            for (FieldMeta field : fields) {
                String filedName = field.getFiledName();
                if (!data.containsKey(filedName)) continue;
                Object fieldData = data.get(filedName);
                if (fieldData != null && !"".equals(fieldData)) {
                    FieldValue fvFieldName = new FieldValue(field.getPropertyName() + "_" + field.getDatatype(), fieldData);
                    fvList.add(fvFieldName);
                }
                if (!field.isPy()) continue;
                Object pyValue = data.get(filedName);
                try {
                    pyValue = this.getPYValue(pyValue + "");
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    ExceptionLogger.error(ESFullTextMapper.class, (String)"trans py error ", (Throwable)e);
                }
                FieldValue fvFieldNamePY = new FieldValue(CommonUtils.getPinyinPN(field.getPropertyName()) + "_" + field.getDatatype(), pyValue);
                fvList.add(fvFieldNamePY);
            }
        }
        fvList.forEach(v -> result.put(v.getName(), v.getValue()));
        return result;
    }

    protected Object getPYValue(String pyValue) throws BadHanyuPinyinOutputFormatCombination {
        if (pyValue.length() > PYMAXSTRING) {
            pyValue = pyValue.substring(0, PYMAXSTRING);
        }
        return PinYinUtil.getMergePinyin((String)pyValue);
    }

    public boolean checkTable(String tableName) {
        return EsConfigMonitor.get(this.region).containsTable(tableName) && !DataSyncConfigCache.get().isRelationtable(tableName);
    }

    public String getFieldStoredName(String tableName, String filed) {
        TableMeta tableMeta = EsConfigMonitor.get(this.region).getTableMeta(tableName);
        FieldMeta fieldMeta = tableMeta.getField(filed);
        if (fieldMeta == null) {
            return filed;
        }
        return fieldMeta.getPropertyName() + "_" + fieldMeta.getDatatype();
    }

    public String getIndexName(String object) {
        return CommonUtil.getIndexNamePrefix((String)this.region) + "_data";
    }

    public String getESDataType() {
        return FULLTEXT_DATA_TYPE;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<RowInfo> preHandle(List<RowInfo> rowInfos) {
        return rowInfos;
    }

    public void deleteEntity(String entityNumber) {
        this.getUpdate(this.region).deleteAll(entityNumber);
    }

    public void deleteEntityFileds(String entityNumber, List<MatchProperty> match) {
        this.getUpdate(this.region).deleteProperty(entityNumber, match.toArray(new MatchProperty[0]));
    }

    public void initCreateEntityMeta(String entityNumber, List<MatchProperty> match) {
        FullTextUpdater ftu = this.getUpdate(this.region);
        ftu.addProperty(entityNumber, match.toArray(new MatchProperty[0]));
    }

    private FullTextUpdater getUpdate(String region) {
        return new FullTextUpdaterImpl(region);
    }
}

