/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.mongodb;

import kd.bos.dts.AbstractSqlOutput;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.impl.mongodb.sql.AbstractSqlOperater;
import kd.bos.dts.impl.mongodb.sql.SqlDeleteOperater;
import kd.bos.dts.impl.mongodb.sql.SqlInsertOperater;
import kd.bos.dts.impl.mongodb.sql.SqlUpdateOperater;
import kd.bos.exception.KDException;
import kd.bos.nosql.IndexableTableStorage;
import kd.bos.nosql.StorageFactory;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;

public class MongoSqlOutput
extends AbstractSqlOutput {
    private IndexableTableStorage storage = StorageFactory.getIndexableSotrage();

    public MongoSqlOutput(DestinationTransRule destinationRule) {
        super(destinationRule);
    }

    public void translate(String type, DataSyncValue value) {
        AbstractSqlOperater operater = null;
        if (OperationType.DELETE.getName().equals(type)) {
            operater = new SqlDeleteOperater(this.destinationRule);
        } else if (OperationType.UPDATE.getName().equals(type)) {
            operater = new SqlUpdateOperater(this.destinationRule);
        } else if (OperationType.INSERT.getName().equals(type)) {
            operater = new SqlInsertOperater(this.destinationRule);
        } else {
            throw new KDException(DtsErrorCode.unsupport, new Object[]{type});
        }
        operater.operate(value, this.storage);
    }
}

