/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.impl.mongodb.sql;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dts.impl.Pair;
import kd.bos.dts.impl.mongodb.sql.AbstractSqlOperater;
import kd.bos.dts.ksql.DataSqlUpdateSyncValue;
import kd.bos.nosql.IndexableTableStorage;
import kd.bos.nosql.ResultSet;
import kd.bos.nosql.Row;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;

public class SqlUpdateOperater
extends AbstractSqlOperater {
    public SqlUpdateOperater(DestinationTransRule destinationRule) {
        super(destinationRule);
    }

    @Override
    public void operate(DataSyncValue value, IndexableTableStorage storage) {
        DataSqlUpdateSyncValue update = (DataSqlUpdateSyncValue)value;
        String tableName = update.getTableName();
        String where = update.getWhere();
        List<Pair> pairs = update.getSetPairs();
        if (pairs.size() == 0) {
            return;
        }
        StringBuilder selectSql = new StringBuilder("select ");
        pairs.forEach(v -> selectSql.append(v.getField()).append(","));
        selectSql.setLength(selectSql.length() - 1);
        selectSql.append(" from ").append(tableName).append(" where ").append(where);
        ResultSet rs = storage.query(selectSql.toString());
        ArrayList<Row> ls = new ArrayList<Row>(2);
        while (rs.next()) {
            Row r = new Row();
            r.add("_id", rs.getValue("_id"));
            pairs.forEach(v -> r.add(v.getField(), v.getValue()));
            ls.add(r);
        }
        if (ls.size() > 0) {
            storage.store(tableName, ls.iterator());
        }
    }
}

