/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.caution.GidCaution;
import kd.bos.dts.caution.GidCautionFactory;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.init.DtsConfigureInitSemaphore;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.init.Initialize;
import kd.bos.dts.init.InitializeFactory;
import kd.bos.dts.lock.Lock;
import kd.bos.dts.lock.LockFactory;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.log.DtsStatusType;
import kd.bos.dts.oplog.Oplog;
import kd.bos.dts.oplog.Status;
import kd.bos.dts.rateofprogress.RateofprogressFactory;
import kd.bos.dts.retry.RetryStroage;
import kd.bos.dts.service.DtsConfigMonitor;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.exception.KDException;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.datasync.ConfigureItemStatus;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.DtsThreadContext;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.UpgraderStatus;

public class DtsConfigureConsumer
implements MessageConsumer {
    private static final String REVISE_SQL = "UPDATE T_DTS_DATASYNCCONFIG SET FENABLE = '1' WHERE FID = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Object arg0, String arg1, boolean arg2, MessageAcker acker) {
        Map m = (Map)arg0;
        SyncConfigCompareInfo compare = (SyncConfigCompareInfo)m.get("dts_config_change_key");
        String messageid = compare.getInnerId();
        if (UpgraderStatus.status.isUpgradering()) {
            ExceptionLogger.log(DtsConfigureConsumer.class, (String)("dts is upgradering ,will apply configure later : " + compare));
        }
        if (compare == null) return;
        try {
            DtsConfigureInitSemaphore.getDtsConfigureInitSemaphore().acquire();
            DestinationRuleConfig entityRuleConfig = compare.getDestinationEntityConfig();
            Oplog.get().recordTask(compare, Status.accept_sync_task, messageid);
            OperationType operateType = compare.getOperationStates();
            String compareOperateTypeName = operateType.getName();
            DtsStatusReporterFactory.get().confInitReport(entityRuleConfig, compareOperateTypeName, DtsStatusType.CONFIG_RECIVED);
            String lockkey = DtsUtils.getEntitySplitKey(compare.getEntitynumber(), compare.getDestinationtype(), compare.getRegion(), compare.getMappingrule());
            boolean isrepaire = false;
            Object repair = m.get("repair");
            if (repair != null && "true".equals(repair)) {
                isrepaire = true;
                RateofprogressFactory.get(lockkey).clear();
            }
            try {
                TXHandle h = TX.requiresNew((String)"bos_dts_lock");
                Throwable throwable = null;
                try {
                    List<SyncConfigCompareInfo> compareList;
                    Throwable throwable2;
                    Lock lock;
                    block79: {
                        block80: {
                            block81: {
                                lock = LockFactory.create(lockkey);
                                throwable2 = null;
                                if (!lock.lock()) return;
                                compareList = DtsSnapConfigDao.instance.getDtsConfigChanged(compare.getEntitynumber(), compare.getDestinationtype(), compare.getRegion(), compare.getMappingrule());
                                if (compareList.size() > 1) {
                                    throw new KDException(DtsErrorCode.exectueDBError, new Object[]{lockkey + " query over one "});
                                }
                                if (compareList.size() != 0) break block79;
                                Oplog.get().recordTask(compare, Status.begin_have_finish_sync_task, messageid);
                                DtsStatusReporterFactory.get().confInitReport(entityRuleConfig, compareOperateTypeName, DtsStatusType.CONFIG_NOCHANGE_FINISH);
                                if (lock == null) break block80;
                                if (throwable2 == null) break block81;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                break block80;
                            }
                            lock.close();
                        }
                        if (h == null) return;
                        if (throwable != null) {
                            try {
                                h.close();
                                return;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                return;
                            }
                        }
                        h.close();
                        return;
                    }
                    try {
                        Oplog.get().recordTask(compare, Status.begin_sync_task, messageid);
                        DtsStatusReporterFactory.get().confInitReport(entityRuleConfig, compareOperateTypeName, DtsStatusType.CONFIG_BEGIN_INIT);
                        GidCaution caution = GidCautionFactory.get(lockkey);
                        try {
                            caution.begin();
                            compare = compareList.get(0);
                            compare.setInnerId(messageid);
                            DestinationTransRule ruleType = new DestinationTransRule();
                            ruleType.setType(DestinationType.getType((String)compare.getDestinationtype()));
                            ruleType.setMappingrule(compare.getMappingrule());
                            ruleType.setRegion(compare.getRegion());
                            ruleType.setBusinessType(compare.getBusinessType());
                            Initialize initializer = InitializeFactory.getInitializer(ruleType);
                            DtsSnapConfigDao.instance.updateStatus(compare, ConfigureItemStatus.prepare);
                            if (!initializer.isSkip(compare)) {
                                if (OperationType.INSERT == operateType) {
                                    RetryStroage.get().removeItem(compare.getFid());
                                    initializer.initCreateEntityMeta(compare);
                                    initializer.initImportEntityData(compare);
                                    caution.setChangeFields(compare.getEntityfields());
                                } else if (OperationType.UPDATE == operateType) {
                                    initializer.updateEntity(compare);
                                    String field = compare.getConfiggedNewEntityFileds();
                                    if (compare.getDynEntityfields() != null && !compare.isNewAllFields()) {
                                        field = field + "," + compare.getDynEntityfields();
                                    }
                                    caution.setChangeFields(field);
                                } else if (OperationType.DELETE == operateType) {
                                    initializer.deleteEntity(compare);
                                    caution.setChangeFields(compare.getEntityfields());
                                    RetryStroage.get().removeItem(compare.getFid());
                                }
                                initializer.notifyEndInit(operateType, compare.getEntitynumber());
                            }
                            DtsSnapConfigDao.instance.update(compare);
                            if (isrepaire) {
                                try (TXHandle tx = TX.requiresNew();
                                     DtsThreadContext dtsContext = DtsThreadContext.create();){
                                    DB.execute((DBRoute)DBRoute.basedata, (String)REVISE_SQL, (Object[])new Object[]{compare.getFid()});
                                }
                                DtsConfigMonitor.get().queryAndSend();
                            }
                            caution.setOperationType(operateType.getName());
                            String businessType = compare.getBusinessType();
                            String entityNumber = compare.getEntitynumber();
                            StringBuilder stringBuilder = new StringBuilder("kd.bos.dts.DtsMsgConsumer#DtsConfigureConsumer:");
                            stringBuilder.append(",businessType#").append(businessType);
                            stringBuilder.append(",entityNumber#").append(entityNumber);
                            stringBuilder.append(",operateType#").append(operateType.getName());
                            DtsUtils.logInfo(stringBuilder.toString());
                        }
                        catch (Exception e) {
                            DtsSnapConfigDao.instance.updateStatus(compare, ConfigureItemStatus.prepareError);
                            throw e;
                        }
                        finally {
                            caution.end();
                        }
                        if (isrepaire) {
                            caution.clearAll();
                        }
                        if (OperationType.DELETE == operateType) {
                            Oplog.get().recordTask(compare, Status.end_delete_sync_task, messageid);
                            DtsStatusReporterFactory.get().confInitReport(entityRuleConfig, compareOperateTypeName, DtsStatusType.CONFIG_FINISH_DELETE_INIT);
                            return;
                        }
                        Oplog.get().recordTask(compare, Status.end_sync_task, messageid);
                        DtsStatusReporterFactory.get().confInitReport(entityRuleConfig, compareOperateTypeName, DtsStatusType.CONFIG_FINISH_INIT);
                        return;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                    finally {
                        if (lock != null) {
                            if (throwable2 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                            } else {
                                lock.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    throw throwable9;
                }
            }
            catch (Exception e) {
                Oplog.get().error(compare, ExceptionLogger.getStack((Throwable)e));
                DtsStatusReporterFactory.get().confInitReportError(e, entityRuleConfig);
                return;
            }
        }
        catch (InterruptedException e) {
            ExceptionLogger.log(DtsConfigureConsumer.class, (String)("DtsConfigureConsumer onMessage error: " + e.getMessage()), (Throwable)e);
            return;
        }
        finally {
            DtsConfigureInitSemaphore.getDtsConfigureInitSemaphore().release();
        }
    }
}

