/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.RowInfo;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ApplyException;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.init.AbstractRowGenerator;
import kd.bos.dts.init.DtsShardIndexContext;
import kd.bos.dts.init.QueryGenRow;
import kd.bos.dts.init.QueryGenRowEntry;
import kd.bos.dts.init.QueryGenRowMetaTable;
import kd.bos.dts.init.QueryGenRowMulitWithSqlQuery;
import kd.bos.dts.init.async.AsyncInitializeImport;
import kd.bos.dts.latch.BatchLatchFactory;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.log.DtsStatusType;
import kd.bos.dts.oplog.Oplog;
import kd.bos.dts.oplog.Status;
import kd.bos.dts.rateofprogress.Rateofprogress;
import kd.bos.dts.rateofprogress.RateofprogressFactory;
import kd.bos.dts.rateofprogress.RateofprogressInfo;
import kd.bos.dts.retry.DtsRetryContext;
import kd.bos.dts.retry.Retry;
import kd.bos.dts.retry.RetrySourceType;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.MetaTable;
import kd.bos.orm.datasync.agent.RelationTablesCache;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;

public class QueryAndImport {
    private QueryAndImport() {
    }

    public static QueryAndImport get() {
        return Holder.instance;
    }

    private String assembleSelectFileds(SyncConfigInfo scinfo, String pk, String orderBys) {
        String filedsStr = scinfo.getEntityfields();
        if (filedsStr != null && filedsStr.trim().length() > 0 && !"*".equals(filedsStr)) {
            String[] split;
            HashSet<String> filedSet = new HashSet<String>(4);
            for (String s : split = filedsStr.split(",")) {
                if (StringUtils.isEmpty((String)s)) continue;
                filedSet.add(s);
            }
            if (pk != null) {
                filedSet.add(pk);
            }
            if (orderBys != null) {
                String[] appendFields;
                for (String appendField : appendFields = orderBys.split(",")) {
                    filedSet.add(appendField.split(" ")[0].trim());
                }
            }
            filedsStr = filedSet.stream().collect(Collectors.joining(","));
        } else {
            filedsStr = "*";
        }
        return filedsStr;
    }

    private DataSet getSourceDb(SyncConfigInfo scinfo, ISimpleProperty pk, String where, String orderBys) {
        String entityNumber = scinfo.getEntitynumber();
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        String mainTableName = entityType.getAlias().toLowerCase();
        long shardIndex = DtsShardIndexContext.getShardIndex();
        String tableName = shardIndex == -1L ? mainTableName : TableName.of((String)mainTableName).getShardingTable(shardIndex);
        String pkField = null;
        if (pk != null) {
            pkField = pk.getAlias();
        }
        String filedsStr = this.assembleSelectFileds(scinfo, pkField, orderBys);
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(filedsStr).append(" from ").append(tableName);
        if (where != null) {
            sql.append(" where ").append(where);
        }
        if (orderBys != null) {
            sql.append(" order by ").append(orderBys);
        }
        String querySql = NoShardingHint.genNoShardingSQL((String)sql.toString());
        DataSet dataSet = DB.queryDataSet((String)"QueryAndImporyBd", (DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)querySql);
        return dataSet;
    }

    private DataSet getSource(SyncConfigInfo scinfo, ISimpleProperty pk, QFilter[] filters, String orderBys) {
        String entityNumber = scinfo.getEntitynumber();
        String pkField = null;
        if (pk != null) {
            pkField = pk.getName();
        }
        String filedsStr = this.assembleSelectFileds(scinfo, pkField, orderBys);
        return this.getSource(DestinationType.getType((String)scinfo.getDestinationtype()), entityNumber, filedsStr, filters, orderBys);
    }

    private DataSet getSource(DestinationType destinationType, String entityNumber, String filedsStr, QFilter[] filters, String orderBys) {
        ORM orm = ORM.create();
        if (DestinationType.BUSINESSDB == destinationType) {
            orm.hint().$setConvertField(false);
        }
        if (orderBys != null) {
            DataSet ds = orm.queryDataSet(entityNumber, entityNumber, filedsStr, filters, orderBys);
            return ds;
        }
        DataSet ds = orm.queryDataSet(entityNumber, entityNumber, filedsStr, filters);
        return ds;
    }

    public void initImportData(DestinationTransRule destinationTransRule, SyncConfigInfo scinfo, int batchSize, Consumer<List<RowInfo>> consumer) {
        String entityNumber = scinfo.getEntitynumber();
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        ISimpleProperty pk = entityType.getPrimaryKey();
        if (-5 == pk.getDbType() && scinfo.getTimingSequenceField() == null) {
            scinfo.setTimingSequenceField(pk.getName());
        }
        this.importData(destinationTransRule, scinfo, batchSize, consumer, null, true);
    }

    public void importData(DestinationTransRule destination, SyncConfigInfo scinfo, int batchSize, Consumer<List<RowInfo>> consumer, QFilter[] filters) {
        this.importData(destination, scinfo, batchSize, consumer, filters, false);
    }

    private void importData(DestinationTransRule destination, SyncConfigInfo scinfo, int batchSize, Consumer<List<RowInfo>> consumer, QFilter[] filters, boolean init) {
        String entityNumber = scinfo.getEntitynumber();
        String messageid = scinfo.getInnerId();
        String destinationType = destination.getType().getName();
        String entityKey = DtsUtils.getEntitySplitKey(entityNumber, destinationType, destination.getRegion(), destination.getMappingrule());
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        String mainTableName = entityType.getAlias().toLowerCase();
        ISimpleProperty pk = entityType.getPrimaryKey();
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        HashMap<String, String> mulitfieldsMap = new HashMap<String, String>();
        AtomicBoolean hasMultiFiled = new AtomicBoolean(false);
        HashSet<String> fileds = new HashSet<String>();
        String entityFieldsStr = scinfo.getEntityfields();
        if (entityFieldsStr != null && !scinfo.isAllFields()) {
            for (String f : entityFieldsStr.split(",")) {
                if (StringUtils.isEmpty((String)f)) continue;
                fileds.add(f);
            }
        }
        ArrayList other = new ArrayList();
        entityType.getProperties().forEach(v -> {
            if (!(v instanceof DynamicCollectionProperty)) {
                String k = v.getName();
                try {
                    if (Class.forName("kd.bos.entity.property.MuliLangTextProp").isAssignableFrom(v.getClass())) {
                        if (!fileds.isEmpty() && !fileds.contains(k)) return;
                        hasMultiFiled.set(true);
                        mulitfieldsMap.put(k, v.getAlias().toLowerCase());
                        if (!this.isGLField((IDataEntityType)entityType, k)) return;
                        fieldsMap.put(k, v.getAlias().toLowerCase());
                        return;
                    }
                    fieldsMap.put(k, v.getAlias());
                    return;
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, DtsErrorCode.dtserror, new Object[]{"MuliLangTextProp not found"});
                }
            } else {
                other.add(v);
            }
        });
        fieldsMap.put(pk.getName(), pk.getAlias());
        boolean isBdSync = destination.getType() == DestinationType.BUSINESSDB;
        String orderBy = null;
        String where = null;
        String timingSequenceField = init ? scinfo.getTimingSequenceField() : "";
        Rateofprogress rateofprogress = RateofprogressFactory.get(entityKey);
        RateofprogressInfo rateInfo = rateofprogress.getRatePosition();
        String dbTimingSequenceField = null;
        if (StringUtils.isNotEmpty((String)timingSequenceField)) {
            dbTimingSequenceField = (String)fieldsMap.get(timingSequenceField);
            if (dbTimingSequenceField == null) {
                for (Map.Entry entry : fieldsMap.entrySet()) {
                    if (!((String)entry.getKey()).equalsIgnoreCase(timingSequenceField)) continue;
                    dbTimingSequenceField = (String)entry.getValue();
                    break;
                }
            }
            orderBy = (isBdSync ? dbTimingSequenceField : timingSequenceField) + " asc ";
            if (rateInfo != null && (rateInfo.getLowObject() != null || rateInfo.getHighObject() != null)) {
                Object curTimingSequenceValue = null;
                String cp = null;
                if (rateInfo.getHighObject() != null) {
                    curTimingSequenceValue = rateInfo.getHighObject();
                    cp = ">";
                } else if (rateInfo.getLowObject() != null) {
                    curTimingSequenceValue = rateInfo.getLowObject();
                    cp = ">=";
                    List<Object> idsNeedRemove = rateInfo.getIds();
                    Retry.get().delete(destination, entityNumber, idsNeedRemove, batchSize);
                }
                if (isBdSync) {
                    where = dbTimingSequenceField + " " + cp + " " + curTimingSequenceValue;
                } else {
                    QFilter filter = new QFilter(timingSequenceField, cp, curTimingSequenceValue);
                    filters = new QFilter[]{filter};
                }
            }
        }
        ArrayList<AbstractRowGenerator> rowGenerators = new ArrayList<AbstractRowGenerator>();
        QueryGenRow rowGen = null;
        if (isBdSync) {
            rowGenerators.clear();
            if (init && StringUtils.isNotEmpty((String)timingSequenceField)) {
                HashMap<String, String> rateMap = new HashMap<String, String>();
                rateMap.put(dbTimingSequenceField, dbTimingSequenceField);
                rowGen = new QueryGenRow(entityNumber, mainTableName, pk.getAlias(), rateMap, dbTimingSequenceField);
                rowGen.setConsumData(false);
                rowGenerators.add(rowGen);
            }
            Map metaTableMap = RelationTablesCache.get().getMetaTableMap(entityNumber);
            MetaTable mainMetaTable = (MetaTable)metaTableMap.get(mainTableName.toLowerCase());
            rowGenerators.add(new QueryGenRowMetaTable(mainMetaTable, entityNumber, entityType.getDBRouteKey(), init ? pk.getAlias() : pk.getName()));
            HashSet<String> entityFields = new HashSet<String>(1);
            if (init) {
                entityFields.add(pk.getAlias());
                if (StringUtils.isNotEmpty((String)dbTimingSequenceField)) {
                    entityFields.add(dbTimingSequenceField);
                }
            } else {
                entityFields.add(pk.getName());
                if (StringUtils.isNotEmpty((String)timingSequenceField)) {
                    entityFields.add(timingSequenceField);
                }
            }
            scinfo.setConfiggedEntityfields(String.join((CharSequence)",", entityFields));
        } else {
            rowGen = new QueryGenRow(entityNumber, mainTableName, pk.getName(), fieldsMap, timingSequenceField);
            rowGenerators.add(rowGen);
            if (hasMultiFiled.get()) {
                rowGenerators.add(new QueryGenRowMulitWithSqlQuery(mainTableName, entityType, mulitfieldsMap, pk));
            }
            other.forEach(v -> {
                try {
                    String alias;
                    if (Class.forName("kd.bos.entity.property.EntryProp").isAssignableFrom(v.getClass()) && (alias = ((DynamicCollectionProperty)v).getItemType().getAlias()) != null && alias.length() > 0) {
                        rowGenerators.addAll(QueryGenRowEntry.createRowGenerators((DynamicCollectionProperty)v, pk));
                    }
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, DtsErrorCode.dtserror, new Object[]{"EntryProp not found"});
                }
            });
        }
        DestinationRuleConfig entityRuleConfig = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)destination);
        Consumer<ApplyException> logOp = e -> {
            Thread.interrupted();
            List ids = e.getErrorIds();
            String msg = e.getMsg() + ",failureIds:" + ids;
            Oplog.get().error(destinationType + "-" + destination.getRegion(), "initImport", entityNumber, ids.size(), msg);
            DtsStatusReporterFactory.get().confInitCountReportError((Exception)e, entityRuleConfig, ids.size(), "initImport");
            if (DtsRetryContext.isSource(RetrySourceType.ASYNCSENDED)) {
                Retry.get().failedForRetryIds(destination, entityNumber, ids);
            } else if (!DtsRetryContext.isSource(RetrySourceType.BACKGROUNDTASK)) {
                Retry.get().send(destination, entityNumber, ids);
            }
        };
        int total = 0;
        long shardIndex = -1L;
        String routeKey = entityType.getDBRouteKey();
        shardIndex = init && DB.isSharded((String)mainTableName) ? (rateInfo != null && rateInfo.getShardIndex() != null ? ((Long)rateInfo.getShardIndex()).longValue() : this.getFirstShardingIndex(DBRoute.of((String)routeKey), mainTableName)) : -1L;
        do {
            try (DtsShardIndexContext shardIndexContext = DtsShardIndexContext.create(shardIndex);){
                Supplier<DataSet> valueSupplier;
                String localOrderBy = orderBy;
                if (isBdSync && init) {
                    String localWhere = where;
                    valueSupplier = () -> this.getSourceDb(scinfo, pk, localWhere, localOrderBy);
                } else {
                    QFilter[] localFilters = filters;
                    valueSupplier = () -> this.getSource(scinfo, pk, localFilters, localOrderBy);
                }
                try (DataSet ds = valueSupplier.get();){
                    RowMeta rowMeta = ds.getRowMeta();
                    String[] fieldNames = rowMeta.getFieldNames();
                    int i = 0;
                    while (ds.hasNext()) {
                        Row r = ds.next();
                        rowGenerators.forEach(generator -> generator.gen(r, fieldNames));
                        ++total;
                        if (++i < batchSize) continue;
                        this.accept(entityKey, consumer, rowGenerators, rowGen, logOp, destination);
                        String filterdesc = Status.have_sync_initdata + ":" + this.getShardIndexOfProgress() + "curTotal=" + total + ";size=" + i + this.getFiltersDesc(filters) + this.getRateOfProgress(rowGen);
                        if (StringUtils.isNotEmpty((String)messageid)) {
                            filterdesc = "messageid: " + messageid + "," + filterdesc;
                        }
                        Oplog.get().recordInitImport(destinationType + "-" + destination.getRegion(), OperationType.INSERT.getName(), entityNumber, filterdesc);
                        DtsStatusReporterFactory.get().confInitCountReport(entityRuleConfig, OperationType.INSERT.getName(), DtsStatusType.CONFIG_DOINIT_COUNT, total, filterdesc);
                        rowGenerators.forEach(generator -> generator.clear());
                        i = 0;
                    }
                    if (i > 0) {
                        this.accept(entityKey, consumer, rowGenerators, rowGen, logOp, destination);
                        String filterdesc = Status.have_sync_initdata + ":" + this.getShardIndexOfProgress() + "curTotal=" + total + ";size=" + i + this.getFiltersDesc(filters) + this.getRateOfProgress(rowGen);
                        if (StringUtils.isNotEmpty((String)messageid)) {
                            filterdesc = "messageid: " + messageid + ";" + filterdesc;
                        }
                        Oplog.get().recordInitImport(destinationType + "-" + destination.getRegion(), OperationType.INSERT.getName(), entityNumber, filterdesc);
                        DtsStatusReporterFactory.get().confInitCountReport(entityRuleConfig, OperationType.INSERT.getName(), DtsStatusType.CONFIG_DOINIT_COUNT, total, filterdesc);
                        rowGenerators.forEach(generator -> generator.clear());
                    }
                }
            }
            if (!init || !DB.isSharded((String)mainTableName)) continue;
            shardIndex = this.getNextShardingIndex(DBRoute.of((String)routeKey), mainTableName, shardIndex);
        } while (shardIndex != -1L);
        RateofprogressFactory.get(entityKey).clear();
    }

    private void accept(String entityKey, Consumer<List<RowInfo>> consumer, List<AbstractRowGenerator> rowGenerators, QueryGenRow rowGen, Consumer<ApplyException> logOp, DestinationTransRule destination) {
        if (rowGen != null && rowGen.hasTimingSequenceField()) {
            ArrayList<Object> pkList = new ArrayList<Object>();
            pkList.addAll(rowGen.getPKList());
            Object low = rowGen.getBatchLowTimeSeqValue();
            Object high = rowGen.getBatchHighTimeSeqValue();
            Rateofprogress rateofprogress = RateofprogressFactory.get(entityKey);
            try {
                rateofprogress.begin(low, pkList);
                rowGenerators.forEach(v -> v.consumDatas(consumer));
                rateofprogress.end(high);
            }
            catch (ApplyException e) {
                logOp.accept(e);
            }
        } else {
            try {
                rowGenerators.forEach(v -> v.consumDatas(consumer));
            }
            catch (ApplyException e) {
                logOp.accept(e);
            }
        }
    }

    private void send(List<AbstractRowGenerator> rowGenerators, DestinationTransRule destination, String entityKey, int batchCount) {
        String batchId = UUID.randomUUID().toString().substring(1, 26);
        AsyncInitializeImport.get().send(batchId, rowGenerators, destination, entityKey, batchCount);
        BatchLatchFactory.get(entityKey).countProduce(batchId, batchCount);
    }

    private String getFiltersDesc(QFilter[] filters) {
        StringBuilder sb = new StringBuilder();
        sb.append(";filter=");
        sb.append("[");
        StringBuilder filterStr = new StringBuilder();
        if (null != filters) {
            for (int i = 0; i < filters.length; ++i) {
                filterStr.append(filters[i].toString());
                if (filterStr.length() > 256) {
                    filterStr.setLength(256);
                    break;
                }
                if (i == filters.length - 1) continue;
                filterStr.append(",");
            }
        }
        return sb.append((CharSequence)filterStr).append("]").toString();
    }

    private String getShardIndexOfProgress() {
        StringBuilder sb = new StringBuilder();
        long shardIndex = DtsShardIndexContext.getShardIndex();
        if (shardIndex != -1L) {
            sb.append("shardIndex=").append(shardIndex).append(";");
        }
        return sb.toString();
    }

    private String getRateOfProgress(QueryGenRow rowGen) {
        StringBuilder sb = new StringBuilder();
        if (rowGen != null && rowGen.hasTimingSequenceField()) {
            sb.append(";");
            sb.append(rowGen.getTimingSequenceField());
            sb.append("=[");
            Object low = rowGen.getBatchLowTimeSeqValue();
            sb.append("from=").append(low);
            Object high = rowGen.getBatchHighTimeSeqValue();
            sb.append(",to=").append(high);
            sb.append("]");
        }
        return sb.toString();
    }

    private final long getFirstShardingIndex(DBRoute route, String tablename) {
        List<Long> indexList = this.getShardingIndexs(route, tablename);
        if (indexList.isEmpty()) {
            return -1L;
        }
        return indexList.get(0);
    }

    private final long getNextShardingIndex(DBRoute route, String tablename, long curIndex) {
        List<Long> indexList = this.getShardingIndexs(route, tablename);
        if (indexList.isEmpty()) {
            return -1L;
        }
        int size = indexList.size();
        int curSize = 0;
        for (int i = 0; i < size; ++i) {
            if (indexList.get(i) != curIndex) continue;
            curSize = i;
            break;
        }
        if (curSize < size - 1) {
            return indexList.get(curSize + 1);
        }
        return -1L;
    }

    private final List<Long> getShardingIndexs(DBRoute route, String tablename) {
        if (DB.isXDBEnable()) {
            try {
                return (List)DB.__setupExtContextForUsingXdbTableManager((DBRoute)route, (boolean)false, () -> {
                    ArrayList indexList = new ArrayList(1);
                    TableManager tm = XDBConfig.getTableManager();
                    List<String> shardingTables = Arrays.asList(tm.getShardingTable(tablename));
                    shardingTables.forEach(item -> indexList.add(TableName.of((String)item).getShardingIndex()));
                    Collections.sort(indexList);
                    return indexList;
                });
            }
            catch (Exception e) {
                ExceptionLogger.log(Oplog.class, (String)("dtslog:" + ExceptionLogger.getStack((Throwable)e)));
            }
        }
        return new ArrayList<Long>(1);
    }

    private boolean isGLField(IDataEntityType mainDT, String propertyName) {
        IDataEntityProperty peropertyType;
        ISimpleProperty mainProperty;
        return mainDT != null && (mainProperty = (ISimpleProperty)(peropertyType = (IDataEntityProperty)mainDT.getProperties().get((Object)propertyName))) != null && !mainProperty.isDbIgnore() && !peropertyType.isDbIgnore();
    }

    private static class Holder {
        private static QueryAndImport instance = new QueryAndImport();

        private Holder() {
        }
    }
}

