/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dts.RowInfo;
import kd.bos.dts.init.AbstractRowGenerator;
import kd.bos.orm.datasync.OperationType;

public class QueryGenRow
extends AbstractRowGenerator {
    private static final long serialVersionUID = -7033916388692702163L;
    private String tableName;
    private String pkName;
    private String entityNumber;
    private Map<String, String> fieldsMap;
    private String timingSequenceField;
    private List<Object> pkList = new ArrayList<Object>();
    private Object batchLowTimeSeqValue = null;
    private Object batchHighTimeSeqValue = null;

    public QueryGenRow(String entityNumber, String tableName, String pkName, Map<String, String> fieldsMap, String timingSequenceField) {
        this.entityNumber = entityNumber;
        this.tableName = tableName;
        this.pkName = pkName;
        this.fieldsMap = fieldsMap;
        this.timingSequenceField = timingSequenceField;
    }

    @Override
    public String getName() {
        return "QueryGenRow";
    }

    @Override
    public void gen(Row r, String[] fieldNames) {
        RowInfo ri = new RowInfo();
        ri.setType(OperationType.INSERT.getName());
        ri.setTable(this.tableName);
        ri.setKey(r.get(this.pkName));
        this.pkList.add(r.get(this.pkName));
        for (String fieldName : fieldNames) {
            String dbFieldName = this.fieldsMap.get(fieldName);
            if (dbFieldName == null) continue;
            Object v = r.get(fieldName);
            ri.getData().put(dbFieldName.toLowerCase(), v);
            if (!fieldName.equals(this.timingSequenceField)) continue;
            if (this.batchLowTimeSeqValue == null) {
                this.batchLowTimeSeqValue = v;
            }
            this.batchHighTimeSeqValue = v;
        }
        this.consumrDatas.add(ri);
    }

    public Object getBatchLowTimeSeqValue() {
        return this.batchLowTimeSeqValue;
    }

    public Object getBatchHighTimeSeqValue() {
        return this.batchHighTimeSeqValue;
    }

    public List<Object> getPKList() {
        return this.pkList;
    }

    public boolean hasTimingSequenceField() {
        return this.timingSequenceField != null;
    }

    public String getTimingSequenceField() {
        return this.timingSequenceField;
    }

    @Override
    public void clear() {
        super.clear();
        this.pkList.clear();
        this.batchLowTimeSeqValue = null;
        this.batchHighTimeSeqValue = null;
    }

    public int getCount() {
        return this.consumrDatas.size();
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }
}

