/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.RowInfo;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.init.AbstractRowGenerator;
import kd.bos.dts.init.PKWrapper;
import kd.bos.exception.KDException;
import kd.bos.orm.datasync.OperationType;

public class QueryGenRowEntry
extends AbstractRowGenerator {
    private static final long serialVersionUID = -877169369539104666L;
    private List<Object> pkList = new ArrayList<Object>();
    private String tableName;
    private PKWrapper parentPk;
    private ISimpleProperty selfPk;
    private String routeKey;
    private List<String> entryFileds = new ArrayList<String>();

    public static List<QueryGenRowEntry> createRowGenerators(DynamicCollectionProperty entry, ISimpleProperty pk) {
        ArrayList<QueryGenRowEntry> rowGenerators = new ArrayList<QueryGenRowEntry>();
        String tableName = entry.getItemType().getAlias().toLowerCase();
        HashMap<String, List> splitTableEntryFileds = new HashMap<String, List>();
        ArrayList<String> entryFileds = new ArrayList<String>();
        entry.getItemType().getProperties().forEach(p -> {
            String alias = p.getAlias();
            if (!(p instanceof DynamicCollectionProperty) && alias != null && alias.length() > 0) {
                String tableGroup = p.getTableGroup();
                if (tableGroup == null) {
                    try {
                        if (Class.forName("kd.bos.entity.property.MuliLangTextProp").isAssignableFrom(p.getClass())) {
                            tableGroup = null;
                        }
                        entryFileds.add(p.getAlias());
                    }
                    catch (Exception e) {
                        throw new KDException((Throwable)e, DtsErrorCode.dtserror, new Object[]{"MuliLangTextProp not found"});
                    }
                } else {
                    splitTableEntryFileds.computeIfAbsent(tableGroup, g -> new ArrayList()).add(p.getAlias());
                }
            }
        });
        QueryGenRowEntry rowEntryGen = new QueryGenRowEntry(entry, pk, tableName, entryFileds);
        splitTableEntryFileds.forEach((splitTable_suff, v) -> rowGenerators.add(new QueryGenRowEntry(entry, pk, tableName + "_" + splitTable_suff, (List<String>)v)));
        rowGenerators.add(rowEntryGen);
        return rowGenerators;
    }

    public QueryGenRowEntry(DynamicCollectionProperty entry, ISimpleProperty pk, String tableName, List<String> entryFileds) {
        this.parentPk = new PKWrapper(pk);
        this.selfPk = entry.getItemType().getPrimaryKey();
        this.routeKey = entry.getItemType().getDBRouteKey();
        this.tableName = tableName;
        this.entryFileds = entryFileds;
    }

    @Override
    public String getName() {
        return "QueryGenRowEntry";
    }

    @Override
    public void gen(Row r, String[] fieldNames) {
        this.pkList.add(r.get(this.parentPk.getName()));
    }

    @Override
    public void consumDatas(Consumer<List<RowInfo>> consumer) {
        StringBuilder sb = new StringBuilder("select ");
        String pkAlias = this.parentPk.getAlias();
        String selfPkAlias = this.selfPk.getAlias();
        if (!this.entryFileds.contains(pkAlias)) {
            this.entryFileds.add(pkAlias);
        }
        if (!this.entryFileds.contains(selfPkAlias)) {
            this.entryFileds.add(selfPkAlias);
        }
        sb.append(this.entryFileds.stream().collect(Collectors.joining(",")));
        sb.append(" from ").append(this.tableName).append(" where ").append(this.parentPk.getAlias()).append(" in (");
        for (int i = this.pkList.size() - 1; i >= 0; --i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        try (DataSet ds = DB.queryDataSet((String)("QueryGenRowEntry_" + this.tableName), (DBRoute)DBRoute.of((String)this.routeKey), (String)sb.toString(), (Object[])this.pkList.toArray());){
            int batchSize = this.getBatchSize() * 10;
            ArrayList<RowInfo> consumrDatas = new ArrayList<RowInfo>(4);
            while (ds.hasNext()) {
                Row r = ds.next();
                RowInfo ri = new RowInfo();
                ri.setType(OperationType.INSERT.getName());
                ri.setTable(this.tableName);
                ri.setKey(r.get(pkAlias));
                this.entryFileds.forEach(fieldName -> ri.getData().put(fieldName.toLowerCase(), r.get(fieldName)));
                consumrDatas.add(ri);
                if (consumrDatas.size() <= batchSize) continue;
                consumer.accept(consumrDatas);
                consumrDatas.clear();
            }
            if (!consumrDatas.isEmpty()) {
                consumer.accept(consumrDatas);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.pkList.clear();
    }
}

