/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.RowInfo;
import kd.bos.dts.init.AbstractRowGenerator;
import kd.bos.dts.init.DtsShardIndexContext;
import kd.bos.ksql.KSQLThreadCache;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.MetaTable;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.TableName;

public class QueryGenRowMetaTable
extends AbstractRowGenerator {
    private List<Object> pkList = new ArrayList<Object>();
    private String pk;
    private MetaTable mainMetaTable;
    private String routeKey;
    private String entityNumber;

    public QueryGenRowMetaTable(MetaTable mainMetaTable, String entityNumber, String routeKey, String pkName) {
        this.mainMetaTable = mainMetaTable;
        this.entityNumber = entityNumber;
        this.routeKey = routeKey;
        this.pk = pkName;
    }

    @Override
    public String getName() {
        return "QueryGenRowMetaTable";
    }

    @Override
    public void gen(Row r, String[] fieldNames) {
        this.pkList.add(r.get(this.pk));
    }

    @Override
    public void consumDatas(Consumer<List<RowInfo>> consumer) {
        KSQLThreadCache.put((Object)"check.selectAllColumn", (Object)false);
        this.doConsumDatas(this.mainMetaTable, this.pkList, consumer);
    }

    private void doConsumDatas(MetaTable metaTable, List<Object> joinFieldValues, Consumer<List<RowInfo>> consumer) {
        StringBuilder inSQL = new StringBuilder(joinFieldValues.size() * 2 + 6).append(" in (");
        int n = joinFieldValues.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                inSQL.append(',');
            }
            inSQL.append('?');
        }
        inSQL.append(')');
        String currentTable = metaTable.getTableName();
        long shardIndex = DtsShardIndexContext.getShardIndex();
        String queryTrueTable = shardIndex == -1L || !DB.isSharded((String)currentTable) ? currentTable : TableName.of((String)currentTable).getShardingTable(shardIndex);
        String currentPrimaryKey = metaTable.getPrimaryKey();
        StringBuilder sql = new StringBuilder(128);
        String relationField = StringUtils.isEmpty((String)metaTable.getRelationField()) ? metaTable.getPrimaryKey() : metaTable.getRelationField();
        sql.append("select * from ").append(queryTrueTable).append(" where ").append(relationField).append((CharSequence)inSQL);
        String querySql = shardIndex == -1L ? sql.toString() : NoShardingHint.genNoShardingSQL((String)sql.toString());
        try (DataSet ds = DB.queryDataSet((String)("QueryGenRowMetaTable" + queryTrueTable), (DBRoute)DBRoute.of((String)this.routeKey), (String)querySql, (Object[])joinFieldValues.toArray());){
            String[] fieldNames = ds.getRowMeta().getFieldNames();
            int batchSize = metaTable.hasChildren() ? this.getBatchSize() : this.getBatchSize() * 10;
            ArrayList<RowInfo> consumDatas = new ArrayList<RowInfo>(4);
            ArrayList<Object> currentPks = new ArrayList<Object>(4);
            while (ds.hasNext()) {
                Row r = ds.next();
                RowInfo ri = new RowInfo();
                ri.setType(OperationType.INSERT.getName());
                ri.setTable(currentTable);
                ri.setEntityNumber(this.entityNumber);
                Object currentPkValue = r.get(currentPrimaryKey);
                ri.setKey(currentPkValue);
                for (String fieldName : fieldNames) {
                    ri.getData().put(fieldName, r.get(fieldName));
                }
                currentPks.add(currentPkValue);
                consumDatas.add(ri);
                if (consumDatas.size() <= batchSize) continue;
                this.doConsumer(consumDatas, consumer, metaTable, currentPks);
            }
            if (!consumDatas.isEmpty()) {
                this.doConsumer(consumDatas, consumer, metaTable, currentPks);
            }
        }
    }

    private void doConsumer(List<RowInfo> consumrDatas, Consumer<List<RowInfo>> consumer, MetaTable metaTable, List<Object> joinFieldValues) {
        consumer.accept(consumrDatas);
        if (joinFieldValues.size() > 0 && !metaTable.getChildrenTableMap().isEmpty()) {
            for (MetaTable childrenMetaTable : new ArrayList(metaTable.getChildrenTableMap().values())) {
                this.doConsumDatas(childrenMetaTable, joinFieldValues, consumer);
            }
        }
        joinFieldValues.clear();
        consumrDatas.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.pkList.clear();
    }
}

