/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.RowInfo;
import kd.bos.dts.init.AbstractRowGenerator;
import kd.bos.dts.init.PKWrapper;
import kd.bos.ksql.KSQLThreadCache;
import kd.bos.orm.datasync.OperationType;

public class QueryGenRowRelationTable
extends AbstractRowGenerator {
    private static final long serialVersionUID = 3795985107894903164L;
    private List<Object> pkList = new ArrayList<Object>();
    private PKWrapper pk;
    private String relationTableName;
    private String relationField;
    private String routeKey;

    public QueryGenRowRelationTable(String relationTableName, DynamicObjectType entityType, ISimpleProperty pk, String relationField) {
        this.relationTableName = relationTableName;
        this.relationField = relationField;
        this.routeKey = entityType.getDBRouteKey();
        this.pk = new PKWrapper(pk);
    }

    @Override
    public String getName() {
        return "QueryGenRowRelationTable";
    }

    @Override
    public void gen(Row r, String[] fieldNames) {
        this.pkList.add(r.get(this.pk.getName()));
    }

    @Override
    public void consumDatas(Consumer<List<RowInfo>> consumer) {
        KSQLThreadCache.put((Object)"check.selectAllColumn", (Object)false);
        StringBuilder sb = new StringBuilder("select * ");
        sb.append(" from ").append(this.relationTableName).append(" where ").append(this.relationField).append(" in (");
        for (int i = this.pkList.size() - 1; i >= 0; --i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        try (DataSet ds = DB.queryDataSet((String)("QueryGenRowRelationTable" + this.relationTableName), (DBRoute)DBRoute.of((String)this.routeKey), (String)sb.toString(), (Object[])this.pkList.toArray());){
            String[] fieldNames = ds.getRowMeta().getFieldNames();
            int batchSize = this.getBatchSize() * 10;
            ArrayList<RowInfo> consumrDatas = new ArrayList<RowInfo>(4);
            while (ds.hasNext()) {
                Row r = ds.next();
                RowInfo ri = new RowInfo();
                ri.setType(OperationType.INSERT.getName());
                ri.setTable(this.relationTableName);
                ri.setKey(r.get(this.relationField));
                for (String fieldName : fieldNames) {
                    ri.getData().put(fieldName, r.get(fieldName));
                }
                consumrDatas.add(ri);
                if (consumrDatas.size() <= batchSize) continue;
                consumer.accept(consumrDatas);
                consumrDatas.clear();
            }
            if (!consumrDatas.isEmpty()) {
                consumer.accept(consumrDatas);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.pkList.clear();
    }
}

