/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init.async;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.init.AbstractRowGenerator;
import kd.bos.dts.init.QueryGenRow;
import kd.bos.dts.init.async.AsyncInitializeImport;
import kd.bos.dts.latch.BatchLatch;
import kd.bos.dts.latch.BatchLatchFactory;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.log.DtsStatusType;
import kd.bos.dts.oplog.Oplog;
import kd.bos.dts.oplog.Status;
import kd.bos.dts.retry.Retry;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;

public class AsyncInitializeImportConsumer
implements MessageConsumer {
    public void onMessage(Object arg0, String arg1, boolean arg2, MessageAcker arg3) {
        BatchLatch latch;
        int batchCount;
        String entityKey;
        DestinationRuleConfig entityRuleConfig;
        DestinationTransRule desttype;
        String batchid;
        block8: {
            Map m = (Map)arg0;
            batchid = (String)m.get("batchId");
            List rowGenerators = (List)m.get("rowGenerators");
            String entityNumber = this.getEntityNumber(rowGenerators);
            desttype = (DestinationTransRule)m.get("consumers");
            entityRuleConfig = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)desttype);
            entityKey = (String)m.get("entityKey");
            batchCount = (Integer)m.get("batchCount");
            latch = BatchLatchFactory.get(entityKey);
            if (!latch.existsPorduceBatchId(batchid)) {
                int i = 1;
                while (!latch.existsPorduceBatchId(batchid)) {
                    LockSupport.parkNanos(100000000L);
                    if (++i <= 200) continue;
                }
                if (i > 200) {
                    return;
                }
            }
            if (latch.existsConsumeBatchId(batchid)) {
                return;
            }
            try {
                if (latch.existsPreConsumeBatchId(batchid)) {
                    QueryGenRow rowGen = null;
                    for (AbstractRowGenerator g : rowGenerators) {
                        if (!(g instanceof QueryGenRow)) continue;
                        rowGen = (QueryGenRow)g;
                        Retry.get().retry(desttype, rowGen.getEntityNumber(), rowGen.getPKList());
                        break block8;
                    }
                    break block8;
                }
                latch.preCountConsume(batchid, batchCount);
                AsyncInitializeImport.get().apply(rowGenerators, desttype, entityKey, batchCount);
            }
            catch (Exception e) {
                arg3.deny(arg1);
                Oplog.get().error(desttype.getType().getName() + "-" + desttype.getRegion(), "async init import", entityKey, batchCount, ExceptionLogger.getStack((Throwable)e));
                DtsStatusReporterFactory.get().confInitCountReportError(e, entityRuleConfig, batchCount, "async init import");
                return;
            }
        }
        this.callend(arg3, arg1, latch, batchid, batchCount, entityKey, desttype, entityRuleConfig);
    }

    private String getEntityNumber(List<AbstractRowGenerator> rowGenerators) {
        for (AbstractRowGenerator row : rowGenerators) {
            if (row == null) continue;
            return ((QueryGenRow)row).getEntityNumber();
        }
        return null;
    }

    private void callend(MessageAcker arg3, String arg1, BatchLatch latch, String batchid, int batchCount, String entityKey, DestinationTransRule desttype, DestinationRuleConfig entityRuleConfig) {
        long total = latch.countConsume(batchid, batchCount);
        arg3.ack(arg1);
        latch.clear(batchid);
        boolean isFinish = latch.isFinish();
        if (isFinish) {
            latch.clear();
        }
        String opname = OperationType.INSERT.getName();
        Oplog.get().recordInitImport(desttype.getType().getName() + "-" + desttype.getRegion(), opname, entityKey, (int)total, Status.have_write_initdata + ";by asycn importer");
        DtsStatusReporterFactory.get().confInitReport(entityRuleConfig, opname, DtsStatusType.CONFIG_DOINIT_COUNT_ASYNC);
        if (isFinish) {
            Oplog.get().recordInitImport(desttype.getType().getName() + "-" + desttype.getRegion(), opname, entityKey, (int)total, Status.end_write_task + ";by asycn importer");
            DtsStatusReporterFactory.get().confInitReport(entityRuleConfig, opname, DtsStatusType.CONFIG_FINISH_INIT_ASYNC);
        }
    }
}

