/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.init.table;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public abstract class AbstractInitTable {
    private Map<String, Boolean> accountCreateMap = new ConcurrentHashMap<String, Boolean>();

    public void initTable() {
        String accoutId = RequestContext.get().getAccountId();
        this.accountCreateMap.computeIfAbsent(accoutId, k -> {
            List<String> alterLs;
            DB.execute((DBRoute)DBRoute.basedata, (String)this.getCreateTableSql());
            List<String> indexLs = this.getCreateIndexSql();
            if (indexLs != null) {
                indexLs.forEach(indexSql -> DB.execute((DBRoute)DBRoute.basedata, (String)indexSql));
            }
            if ((alterLs = this.getAlterTableSql()) != null) {
                alterLs.forEach(alterSql -> DB.execute((DBRoute)DBRoute.basedata, (String)alterSql));
            }
            return true;
        });
    }

    public abstract String getCreateTableSql();

    public List<String> getAlterTableSql() {
        return null;
    }

    public List<String> getCreateIndexSql() {
        return null;
    }

    public abstract String getTableName();
}

