/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dts.ksql.stmt.DtsAlterTableStmtHandler;
import kd.bos.dts.ksql.stmt.DtsDeleteStmtHandler;
import kd.bos.dts.ksql.stmt.DtsExecStmtHandler;
import kd.bos.dts.ksql.stmt.DtsIfStmtHandler;
import kd.bos.dts.ksql.stmt.DtsInsertStmtHandler;
import kd.bos.dts.ksql.stmt.DtsStmtHandler;
import kd.bos.dts.ksql.stmt.DtsUpdateStmtHandler;
import kd.bos.dts.ksql.stmt.UnsupportStmtHandler;
import kd.bos.ksql.dom.stmt.SqlAlterTableStmt;
import kd.bos.ksql.dom.stmt.SqlDeleteStmt;
import kd.bos.ksql.dom.stmt.SqlExecStmt;
import kd.bos.ksql.dom.stmt.SqlIfStmt;
import kd.bos.ksql.dom.stmt.SqlInsertStmt;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;

public class DtsStmtFactory {
    private static ConcurrentHashMap<String, DtsStmtHandler> outputMap = new ConcurrentHashMap();

    public static DtsStmtHandler getDtsStmtParse(SqlStmt stmt) {
        String className = stmt.getClass().getName();
        String accountId = RequestContext.get().getAccountId();
        String contextClassName = accountId + "#" + className;
        return outputMap.computeIfAbsent(contextClassName, x -> {
            if (stmt instanceof SqlUpdateStmt) {
                return new DtsUpdateStmtHandler();
            }
            if (stmt instanceof SqlDeleteStmt) {
                return new DtsDeleteStmtHandler();
            }
            if (stmt instanceof SqlInsertStmt) {
                return new DtsInsertStmtHandler();
            }
            if (stmt instanceof SqlIfStmt) {
                return new DtsIfStmtHandler();
            }
            if (stmt instanceof SqlExecStmt) {
                return new DtsExecStmtHandler();
            }
            if (stmt instanceof SqlAlterTableStmt) {
                return new DtsAlterTableStmtHandler();
            }
            return new UnsupportStmtHandler();
        });
    }
}

