/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql.stmt;

import java.util.Locale;
import kd.bos.dts.ksql.stmt.DtsStmtHandler;
import kd.bos.ksql.dom.expr.SqlBinaryOpExpr;
import kd.bos.ksql.dom.expr.SqlCharExpr;
import kd.bos.ksql.dom.expr.SqlDateTimeExpr;
import kd.bos.ksql.dom.expr.SqlDoubleExpr;
import kd.bos.ksql.dom.expr.SqlIntExpr;
import kd.bos.ksql.dom.expr.SqlLongExpr;
import kd.bos.ksql.dom.expr.SqlNCharExpr;
import kd.bos.ksql.dom.expr.SqlVarRefExpr;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.xdb.tablemanager.TableName;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDtsStmtHandler
implements DtsStmtHandler {
    protected DataSyncConfigCache syncConfig = DataSyncConfigCache.get();

    protected boolean checkTable(String tableName) {
        return tableName != null && !tableName.toLowerCase(Locale.ENGLISH).startsWith("t_meta");
    }

    protected String getOriginalName(String tableName) {
        boolean isShardTable = tableName.lastIndexOf("$") != -1;
        String originalName = isShardTable ? TableName.of((String)tableName).getOriginalName() : tableName;
        return originalName;
    }

    protected Object getExprValue(Object v) {
        Object obj = null;
        if (v instanceof SqlIntExpr) {
            obj = ((SqlIntExpr)v).value;
        } else if (v instanceof SqlCharExpr) {
            obj = ((SqlCharExpr)v).text;
        } else if (v instanceof SqlDateTimeExpr) {
            obj = ((SqlDateTimeExpr)v).getJavaDate();
        } else if (v instanceof SqlDoubleExpr) {
            obj = ((SqlDoubleExpr)v).value;
        } else if (v instanceof SqlLongExpr) {
            obj = ((SqlLongExpr)v).value;
        } else if (v instanceof SqlNCharExpr) {
            obj = ((SqlNCharExpr)v).getJavaString();
        } else if (v instanceof SqlVarRefExpr) {
            obj = ((SqlVarRefExpr)v).text;
        } else if (v instanceof SqlBinaryOpExpr) {
            String exprStr = ((SqlBinaryOpExpr)v).toString();
            int i = StringUtils.countMatches((String)exprStr, (String)"?");
            obj = new ExprCount(i);
        }
        return obj;
    }

    static class ExprCount {
        private int count;

        ExprCount(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

