/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.ksql.stmt;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.impl.Pair;
import kd.bos.dts.ksql.DataSqlUpdateSyncValue;
import kd.bos.dts.ksql.stmt.AbstractDtsStmtHandler;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.dom.stmt.SqlUpdateStmt;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;

public class DtsUpdateStmtHandler
extends AbstractDtsStmtHandler {
    @Override
    public void parse(SqlStmt sqlStmt, String ksql, Object ... params) {
        SqlUpdateStmt updateStmt = (SqlUpdateStmt)sqlStmt;
        String tableName = updateStmt.update.updateTable.name;
        if (!this.checkTable(tableName)) {
            return;
        }
        String whereCondition = null;
        if (updateStmt.update.condition != null) {
            whereCondition = updateStmt.update.condition.toString();
        }
        List updateSetItmes = updateStmt.update.updateList;
        String sourceTableName = this.getOriginalName(tableName);
        DestinationTransRule[] transRules = this.syncConfig.getTransRuleByTableName(sourceTableName);
        if (transRules != null && transRules.length > 0) {
            String entityNumber = this.syncConfig.getEntityNumberByTableName(sourceTableName);
            String routeKey = DtsUtils.getDBRoutKeyByEntityNumber(entityNumber);
            DBRoute route = DBRoute.of((String)routeKey);
            String pkField = DataSyncConfigCache.get().getPrimaryField(entityNumber, sourceTableName);
            DataSqlUpdateSyncValue update = new DataSqlUpdateSyncValue(tableName, entityNumber, pkField, false);
            update.setRouteKey(routeKey);
            update.setWhere(whereCondition);
            AtomicInteger paramIndex = new AtomicInteger(0);
            if (updateSetItmes != null) {
                updateSetItmes.forEach(v -> {
                    Pair p = new Pair();
                    p.setField(v.name);
                    Object val = this.getExprValue(v.expr);
                    if (val instanceof AbstractDtsStmtHandler.ExprCount) {
                        int count = ((AbstractDtsStmtHandler.ExprCount)val).getCount();
                        for (int i = 0; i < count; ++i) {
                            p.setValue(params[paramIndex.getAndIncrement()]);
                        }
                    } else if ("?".equals(val)) {
                        p.setValue(params[paramIndex.getAndIncrement()]);
                    } else {
                        p.setValue(val);
                    }
                    update.addSetPair(p);
                });
            }
            StringBuilder queryIds = new StringBuilder();
            queryIds.append("select ").append(pkField).append(" from ").append(tableName);
            if (whereCondition != null) {
                queryIds.append(" where ").append(whereCondition);
            }
            Object[] queryParam = params;
            if (paramIndex.get() > 0) {
                queryParam = Arrays.copyOfRange(params, paramIndex.get(), params.length);
            }
            try (TXHandle h = TX.requiresNew();){
                try (DataSet ds = DB.queryDataSet((String)"ESSqlOutputgetIDs", (DBRoute)route, (String)queryIds.toString(), (Object[])queryParam);){
                    ds.forEach(v -> update.addId(v.get(pkField)));
                }
                catch (Throwable e) {
                    ExceptionLogger.log(DtsUpdateStmtHandler.class, (String)String.format("DtsSqlHandler query update`s ids error,sql:%s, ksql:%s", queryIds, ksql), (Throwable)e);
                }
            }
            update.setQueryIdSql(queryIds.toString());
            update.setSourceSql(ksql);
            update.setSourceParams(params);
            DataSyncAgent.get().send(route, OperationType.UPDATE, (DataSyncValue)update);
        }
    }
}

