/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.latch;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dts.latch.BatchLatch;
import kd.bos.instance.Instance;

public class BatchLatchRedisImpl
implements BatchLatch {
    private String key;
    private DistributeSessionlessCache store;
    private static final String STORE_KEY = "dts.latch.store." + Instance.getClusterName();
    private static final String PRODUCE_BATCH = "Porduce";
    private static final String CONSUME_BATCH = "Consume";
    private static final String PRE_CONSUME_BATCH = "PreConsume";
    private String countKey;
    private String downCountKey;
    private String isEndKey;
    private String statusKey;

    public BatchLatchRedisImpl(String k) {
        this.key = STORE_KEY + k;
        this.countKey = this.key + "countKey";
        this.downCountKey = this.key + "downCountKey";
        this.isEndKey = this.key + "isEndKey";
        this.statusKey = this.key + "statusKey";
        this.store = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dts");
    }

    @Override
    public long countConsume(String batchId, int count) {
        this.store.put(this.statusKey, this.getConsumeBatchKey(batchId), (Object)String.valueOf(count));
        return this.store.incrBy(this.downCountKey, count);
    }

    @Override
    public long countProduce(String batchId, int count) {
        this.store.put(this.statusKey, this.getPorduceBatchKey(batchId), (Object)String.valueOf(count));
        return this.store.incrBy(this.countKey, count);
    }

    @Override
    public boolean existsPorduceBatchId(String batchId) {
        String v = (String)this.store.get(this.statusKey, this.getPorduceBatchKey(batchId));
        return v != null && v.length() > 0;
    }

    @Override
    public boolean existsConsumeBatchId(String batchId) {
        String v = (String)this.store.get(this.statusKey, this.getConsumeBatchKey(batchId));
        return v != null && v.length() > 0;
    }

    @Override
    public boolean existsPreConsumeBatchId(String batchId) {
        String v = (String)this.store.get(this.statusKey, this.getPreConsumeBatchKey(batchId));
        return v != null && v.length() > 0;
    }

    private String getPorduceBatchKey(String batchId) {
        return PRODUCE_BATCH + batchId;
    }

    private String getConsumeBatchKey(String batchId) {
        return CONSUME_BATCH + batchId;
    }

    private String getPreConsumeBatchKey(String batchId) {
        return PRE_CONSUME_BATCH + batchId;
    }

    @Override
    public void endProduce() {
        this.store.put(this.isEndKey, (Object)"true", Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public void await() {
        String count = (String)this.store.get(this.countKey);
        String downCount = (String)this.store.get(this.downCountKey);
        while (count != null && !count.equals(downCount)) {
            LockSupport.parkNanos(500000000L);
            count = (String)this.store.get(this.countKey);
            downCount = (String)this.store.get(this.downCountKey);
        }
    }

    @Override
    public boolean isFinish() {
        String count = (String)this.store.get(this.countKey);
        String downCount = (String)this.store.get(this.downCountKey);
        String isEnd = (String)this.store.get(this.isEndKey);
        if (count == null) {
            return true;
        }
        return "true".equals(isEnd) && count.equals(downCount);
    }

    @Override
    public void clear() {
        this.store.remove(this.countKey);
        this.store.remove(this.downCountKey);
        this.store.remove(this.isEndKey);
        this.store.remove(this.statusKey);
    }

    @Override
    public void preCountConsume(String batchid, int batchCount) {
        this.store.put(this.statusKey, this.getPreConsumeBatchKey(batchid), (Object)String.valueOf(batchCount));
    }

    @Override
    public void clear(String batchid) {
        this.store.remove(this.statusKey, new String[]{this.getPreConsumeBatchKey(batchid), this.getConsumeBatchKey(batchid), this.getPorduceBatchKey(batchid)});
    }

    @Override
    public void clearAll() {
        List ls = this.store.getKeysWithPrefix(STORE_KEY);
        ls.forEach(key -> this.store.remove(key));
    }
}

