/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.lock.Lock;
import kd.bos.exception.KDException;

public class DBLock
implements Lock {
    private static String tableName = "T_DTS_LOCK";
    private static String createTableSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + tableName + "') CREATE TABLE " + tableName + " (FLOCKKEY varchar(255) NOT NULL PRIMARY KEY)";
    private static String insertSql = "INSERT INTO " + tableName + "(FLOCKKEY) VALUES(?)";
    private static String deleteSql = "delete from " + tableName + " where FLOCKKEY = ?";
    private static Map<String, Boolean> accountCreateMap = new ConcurrentHashMap<String, Boolean>();
    private String lockKey;
    private String accoutId;
    private volatile boolean locked = false;

    DBLock(String key) {
        this.lockKey = key;
        this.accoutId = RequestContext.get().getAccountId();
        if (this.accoutId == null) {
            throw new KDException(DtsErrorCode.cannotbenull, new Object[]{"accoutId"});
        }
        this.initTable(this.accoutId);
    }

    private void initTable(String accoutId) {
        accountCreateMap.computeIfAbsent(accoutId, k -> {
            DB.execute((DBRoute)DBRoute.basedata, (String)createTableSql);
            return true;
        });
    }

    @Override
    public boolean lock() {
        try {
            DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])new Object[]{this.lockKey});
            this.locked = true;
            return true;
        }
        catch (Throwable e) {
            throw new KDException(e, DtsErrorCode.exectueDBError, new Object[]{"DBLock.lock()"});
        }
    }

    @Override
    public void unLock() {
        try {
            if (this.locked) {
                DB.execute((DBRoute)DBRoute.basedata, (String)deleteSql, (Object[])new Object[]{this.lockKey});
                this.locked = false;
            }
        }
        catch (Throwable e) {
            throw new KDException(e, DtsErrorCode.exectueDBError, new Object[]{"DBLock.unLock()"});
        }
    }
}

