/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.operator;

import java.lang.reflect.Field;
import java.util.concurrent.locks.LockSupport;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.caution.GidCaution;
import kd.bos.dts.caution.GidCautionFactory;
import kd.bos.dts.configoperator.DtsConfigOperator;
import kd.bos.dts.configoperator.DtsConfigOperatorInfo;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.service.DtsConfigMonitor;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class DtsConfigOperatorImpl
implements DtsConfigOperator {
    public void saveDtsConfig(DtsConfigOperatorInfo dtsConfigInfo) {
        DtsConfigOperatorImpl.checkParams(dtsConfigInfo);
        DtsSnapConfigDao.instance.insertDataSyncConfig(dtsConfigInfo);
        DtsConfigMonitor.get().queryAndSend(dtsConfigInfo.getEntityNumber(), dtsConfigInfo.getDtsDestType().getCode(), dtsConfigInfo.getRegion(), dtsConfigInfo.getMappingRule());
    }

    public static void checkParams(Object object) {
        try {
            Field[] fs;
            Class<?> aClass = object.getClass();
            for (Field f : fs = aClass.getDeclaredFields()) {
                if ("timingSequence".equals(f.getName()) || "mappingRule".equals(f.getName())) continue;
                f.setAccessible(true);
                Object o = f.get(object);
                if (o == null) {
                    throw new IllegalArgumentException("params " + f.getName() + " is null");
                }
                if (!(o instanceof String[]) || ((String[])o).length != 0) continue;
                throw new IllegalArgumentException("params " + f.getName() + " is empty");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new KDException((Throwable)e, BosErrorCode.paramError, new Object[]{e.getMessage()});
        }
    }

    public void deleteDtsConfig(String entityNumber, String businessType, String region, String mappingRule, String destType) {
        mappingRule = this.checkMappingRule(mappingRule);
        DtsSnapConfigDao.instance.deleteDataSyncConfig(entityNumber, region, businessType, mappingRule, destType);
        DtsConfigMonitor.get().queryAndSend(entityNumber, destType, region, mappingRule);
        while (!DtsSnapConfigDao.instance.getDtsConfigChanged(entityNumber, destType, region, mappingRule).isEmpty()) {
            LockSupport.parkNanos(2000000000L);
        }
    }

    public boolean existsSyncConfigSnapshot(String entityNumber, String businessType, String region, String mappingRule, String destType) {
        mappingRule = this.checkMappingRule(mappingRule);
        return DtsSnapConfigDao.instance.existsSyncConfigSnapshot(entityNumber, region, businessType, mappingRule, destType);
    }

    public void disableDtsConfig(String entityNumber, String businessType, String region, String mappingRule, String destType) {
        mappingRule = this.checkMappingRule(mappingRule);
        DtsSnapConfigDao.instance.updateDataSyncConfigStatus(false, entityNumber, region, businessType, mappingRule, destType);
        DtsConfigMonitor.get().queryAndSend(entityNumber, destType, region, mappingRule);
    }

    public void enableDtsConfig(String entityNumber, String businessType, String region, String mappingRule, String destType) {
        mappingRule = this.checkMappingRule(mappingRule);
        DtsSnapConfigDao.instance.updateDataSyncConfigStatus(true, entityNumber, region, businessType, mappingRule, destType);
        DtsConfigMonitor.get().queryAndSend(entityNumber, destType, region, mappingRule);
    }

    private String checkMappingRule(String mappingRule) {
        if (mappingRule == null || "".equals(mappingRule.trim())) {
            mappingRule = " ";
        }
        return mappingRule;
    }

    public boolean isFullSync(String entityNumber, String region, String destType, String mappingRule) {
        String ckey = DtsUtils.getEntitySplitKey(entityNumber, destType, region, mappingRule);
        GidCaution guation = GidCautionFactory.get(ckey);
        return guation.isInitializing();
    }
}

