/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.oplog;

import java.util.Date;
import java.util.Random;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.orm.datasync.OperationType;
import kd.bos.util.StringUtils;

public class Oplog {
    private static final String INSERT_SQL = "INSERT into T_DTS_LOG(FID,fsyncobject,Ftitle,fsynclog,flogtime) values(?,?,?,?,?);";
    private Random r = new Random(1L);

    private Oplog() {
    }

    public static Oplog get() {
        return OplogHolder.instance;
    }

    public void error(SyncConfigCompareInfo info, String desc) {
        ExceptionLogger.log(Oplog.class, (String)("dtslog:" + desc));
        this.recordTask(info, desc, info.getInnerId());
    }

    public void error(String destinationType, String optype, String entityNumber, int count, String desc) {
        ExceptionLogger.log(Oplog.class, (String)("dtslog:" + desc));
        this.recordError(destinationType, optype + " error", entityNumber, count, desc);
    }

    private void recordError(String destinationType, String optype, String entityNumber, int count, String desc) {
        String syncobj = entityNumber + "[" + destinationType + "]";
        String description = "count: " + count + " [" + desc + "]";
        this.writeRecord(syncobj, optype, description);
    }

    public void recordTask(SyncConfigCompareInfo info, String desc, String messageid) {
        String syncobj = info.getEntitynumber() + "[" + info.getDestinationtype() + "-" + info.getRegion() + "]";
        String title = info.getOperationStates().getName() + "Config";
        if (OperationType.UPDATE == info.getOperationStates()) {
            title = title + ",from [" + info.getConfiggedEntityfields() + "] to [" + info.getConfiggedNewEntityFileds() + "]";
        }
        if (StringUtils.isNotEmpty((String)messageid)) {
            desc = "messageid: " + messageid + "," + desc;
        }
        this.writeRecord(syncobj, title, desc);
    }

    public void recordInitImport(String destinationType, String optype, String entityNumber, int count, String desc) {
        this.recordInitImport(destinationType, optype, entityNumber, desc);
    }

    public void recordInitImport(String destinationType, String optype, String entityNumber, String desc) {
        String syncobj = entityNumber + "[" + destinationType + "]";
        this.writeRecord(syncobj, optype, desc);
    }

    public void record(String destinationType, String optype, String entityNumber, int count, String desc) {
        String syncobj = entityNumber + "[" + destinationType + "]";
        String description = "count: " + count + " [" + desc + "]";
        if (Boolean.getBoolean("dts.record.opt.log")) {
            int i = this.r.nextInt(10);
            if (i == 3) {
                this.writeRecord(syncobj, optype, description);
            }
        } else {
            this.writeRecord(syncobj, optype, description);
        }
    }

    private void writeRecord(String syncobj, String type, String desc) {
        if (desc.length() > 500) {
            desc = desc.substring(0, 490);
        }
        if (type.length() > 100) {
            type = type.substring(0, 99);
        }
        long id = DB.genGlobalLongId();
        try (TXHandle h = TX.requiresNew((String)"bos_dts_Oplog");){
            DB.execute((DBRoute)DBRoute.basedata, (String)INSERT_SQL, (Object[])new Object[]{id, syncobj, type, desc, new Date()});
        }
    }

    private static class OplogHolder {
        private static Oplog instance = new Oplog();

        private OplogHolder() {
        }
    }
}

