/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.retry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import kd.bos.dts.DtsMsgSender;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.OutputFactory;
import kd.bos.dts.OutputIUD;
import kd.bos.dts.RowInfo;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.init.QueryAndImport;
import kd.bos.dts.retry.RetryStroage;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.query.QFilter;

public class Retry {
    private static final String ALLFILTER = "*";

    public static Retry get() {
        return RetryServiceHandler.instance;
    }

    public void send(DestinationTransRule destRule, String entityNumber, List<Object> ids) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("destination", destRule);
        m.put("entityNumber", entityNumber);
        m.put("ids", ids);
        DtsMsgSender.send("dts", "kd.bos.service.dts.sync_data_retry_queue", m);
    }

    public void retry(DestinationTransRule destRule, String entityNumber, List<Object> ids) {
        int batchSize = 1000;
        if (ids.size() <= batchSize) {
            this.subRetry(destRule, entityNumber, ids, batchSize);
        } else {
            ArrayList<Object> subids = new ArrayList<Object>();
            ids.forEach(v -> {
                if (subids.size() < batchSize) {
                    subids.add(v);
                } else {
                    this.subRetry(destRule, entityNumber, subids, batchSize);
                    subids.clear();
                }
            });
            if (!subids.isEmpty()) {
                this.subRetry(destRule, entityNumber, subids, batchSize);
            }
        }
    }

    private void subRetry(DestinationTransRule destRule, String entityNumber, List<Object> ids, int batchSize) {
        this.delete(destRule, entityNumber, ids, batchSize);
        List<Object> filterIds = ids;
        if (DtsUtils.isEntityPkyIsInteger(entityNumber)) {
            ArrayList<Object> realIds = new ArrayList<Object>(ids.size());
            try {
                ids.forEach(id -> {
                    if (id instanceof Long) {
                        realIds.add(id);
                    } else if (id instanceof String) {
                        realIds.add(Long.parseLong((String)id));
                    }
                });
                filterIds = realIds;
            }
            catch (Exception e) {
                filterIds = ids;
            }
        }
        String pkName = DtsUtils.getEntityPKName(entityNumber);
        QFilter filter = new QFilter(pkName, "in", filterIds);
        QFilter[] filters = new QFilter[]{filter};
        SyncConfigInfo scinfo = new SyncConfigInfo();
        scinfo.setEntitynumber(entityNumber);
        scinfo.setConfiggedEntityfields(ALLFILTER);
        OutputIUD outputiud = OutputFactory.getOutputterIUD(destRule);
        Consumer<List<RowInfo>> consumer = data -> outputiud.insertTrans((List<RowInfo>)data);
        LockSupport.parkNanos(5000000L);
        QueryAndImport.get().importData(destRule, scinfo, batchSize, consumer, filters);
    }

    public void delete(DestinationTransRule destRule, String entityNumber, List<Object> ids, int batchSize) {
        String deleteType = OperationType.DELETE.getName();
        ArrayList<RowInfo> esconsumers = new ArrayList<RowInfo>(4);
        String tableName = DtsUtils.getTableNameByEntityNumber(entityNumber);
        OutputIUD outputiud = OutputFactory.getOutputterIUD(destRule);
        for (Object id : ids) {
            RowInfo r = new RowInfo();
            r.setType(deleteType);
            r.setKey(id);
            r.setTable(tableName);
            r.setEntityNumber(entityNumber);
            esconsumers.add(r);
            if (esconsumers.size() <= batchSize) continue;
            outputiud.deleteTrans(esconsumers);
            esconsumers.clear();
        }
        if (esconsumers.size() > 0) {
            outputiud.deleteTrans(esconsumers);
        }
    }

    public void failedForRetryIds(DestinationTransRule destination, String entityNumber, List<Object> ids) {
        RetryStroage.get().store(destination, entityNumber, ids);
        DtsSnapConfigDao.instance.suspendOnlineException(entityNumber, destination);
    }

    private static class RetryServiceHandler {
        private static final Retry instance = new Retry();

        private RetryServiceHandler() {
        }
    }
}

