/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.retry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.PreparedBatch;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.DtsErrorCode;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.retry.RetryStroage;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.DtsThreadContext;

public class RetryStroageDbImpl
implements RetryStroage {
    private static Map<String, RetryStroage> instances = new ConcurrentHashMap<String, RetryStroage>(2);
    private Map<String, SyncConfigInfo> configMap = new HashMap<String, SyncConfigInfo>(1);
    private static final int BATCH_SIZE = 1000;
    private Map<Long, DestinationRuleConfig> configIdMaps = new ConcurrentHashMap<Long, DestinationRuleConfig>(1);
    private String accountId;
    private String inserSql = "insert into t_dts_retryids(fconfigid,fentityid,fid) values(?,?,?)";

    public RetryStroageDbImpl(String accountId) {
        this.accountId = accountId;
    }

    public static RetryStroage getInstance() {
        String accountId = RequestContext.get().getAccountId();
        return instances.computeIfAbsent(accountId, v -> new RetryStroageDbImpl((String)v));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(DestinationTransRule destination, String entityNumber, List<Object> ids) {
        SyncConfigInfo config;
        String key = DtsUtils.getEntitySplitKey(entityNumber, destination.getType().getName(), destination.getRegion(), destination.getMappingrule());
        if (!this.configMap.containsKey(key)) {
            RetryStroageDbImpl retryStroageDbImpl = this;
            synchronized (retryStroageDbImpl) {
                if (!this.configMap.containsKey(key)) {
                    this.initConfigMap();
                }
            }
        }
        if ((config = this.configMap.get(key)) == null) {
            throw new KDException(DtsErrorCode.dtserror, new Object[]{"not config " + key});
        }
        List parts = Lists.partition(ids, (int)1000);
        parts.stream().forEach(list -> this.batchStore((List<Object>)list, config));
    }

    private void batchStore(List<Object> ids, SyncConfigInfo config) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();
             DtsThreadContext dtsContext = DtsThreadContext.create();){
            PreparedBatch batch = DB.prepareBatch((DBRoute)DBRoute.basedata, (String)this.inserSql);
            ids.forEach(v -> {
                batch.setParam(0, (Object)config.getFid());
                String value = v instanceof Long ? "L]]:" + v : (v instanceof String ? "S]]:" + v : "O]]:" + v + ":" + v.getClass().getSimpleName());
                batch.setParam(1, (Object)value);
                long id = IDService.get().genLongId();
                batch.setParam(2, (Object)id);
                batch.addBatch();
            });
            batch.executeBatch();
        }
    }

    private void initConfigMap() {
        this.configMap = DtsSnapConfigDao.instance.getConfigItems();
        this.configIdMaps.clear();
        this.configMap.forEach((k, v) -> {
            DestinationTransRule rule = new DestinationTransRule();
            rule.setBusinessType(v.getBusinessType());
            rule.setMappingrule(v.getMappingrule());
            rule.setRegion(v.getRegion());
            rule.setType(DestinationType.getType((String)v.getDestinationtype()));
            DestinationRuleConfig config = DestinationRuleConfig.get((String)v.getEntitynumber(), (DestinationTransRule)rule);
            this.configIdMaps.put(v.getFid(), config);
        });
    }

    @Override
    public List<Long> queryRetryList() {
        ArrayList<Long> ls = new ArrayList<Long>(8);
        try (DataSet ds = DB.queryDataSet((String)"queryRetryList", (DBRoute)DBRoute.basedata, (String)"select distinct fconfigid from t_dts_retryids");){
            ds.forEach(v -> {
                Long id = v.getLong("fconfigid");
                ls.add(id);
            });
        }
        return ls;
    }

    @Override
    public List<Object> queryRetryIds(Long config) {
        ArrayList<Object> ls = new ArrayList<Object>(8);
        try (DataSet ds = DB.queryDataSet((String)"queryRetryIds", (DBRoute)DBRoute.basedata, (String)"select  fentityid from t_dts_retryids where fconfigid=? ", (Object[])new Object[]{config});){
            ds.forEach(v -> {
                String id = v.getString("fentityid");
                String[] iddes = id.split("]]:");
                String type = iddes[0];
                if ("S".equals(type)) {
                    ls.add(iddes[1]);
                } else if ("L".equals(type)) {
                    ls.add(Long.valueOf(iddes[1]));
                }
            });
        }
        return ls;
    }

    @Override
    public void removeItem(Long v) {
        if (v == null) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();
             DtsThreadContext dtsContext = DtsThreadContext.create();){
            DB.execute((DBRoute)DBRoute.basedata, (String)"delete from t_dts_retryids where fconfigid=? ", (Object[])new Object[]{v});
        }
        catch (Exception e) {
            ExceptionLogger.error(RetryStroageDbImpl.class, (String)"RetryStroageDbImpl.removeItem exception", (Throwable)e);
        }
    }

    public String getAccountId() {
        return this.accountId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DestinationRuleConfig getConfig(Long config) {
        if (!this.configIdMaps.containsKey(config)) {
            RetryStroageDbImpl retryStroageDbImpl = this;
            synchronized (retryStroageDbImpl) {
                if (!this.configIdMaps.containsKey(config)) {
                    this.initConfigMap();
                }
            }
        }
        return this.configIdMaps.get(config);
    }
}

