/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dts.config.change.DtsConfigChangeInfo;
import kd.bos.dts.config.change.DtsConfigChangeListener;
import kd.bos.dts.service.DtsMQueueDefManager;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;

public class DtsConfigChangeMasterListenerImpl
implements DtsConfigChangeListener {
    private String appid;

    public DtsConfigChangeMasterListenerImpl(String appid) {
        this.appid = appid;
    }

    @Override
    public void onConfigChange(DtsConfigChangeInfo info) {
        CountDownLatch latch = new CountDownLatch(1);
        ThreadPools.executeOnce((String)"DtsConfigChangeMasterListener-Change", () -> {
            try {
                ThreadLifeCycleManager.start();
                RequestContext context = RequestContext.create();
                context.setAccountId(info.getAccountId());
                context.setTenantId(info.getTenantId());
                String businessType = info.getBusinessType();
                String entityNumber = info.getEntityName();
                DtsMQueueDefManager.initQueueIfAbsent(businessType, entityNumber);
                Set<String> queueNames = DtsMQueueDefManager.getDtsQueueNames(businessType, entityNumber);
                for (String queueName : queueNames) {
                    Consumer conumer = QueueManager.getLazyInitConsumer((String)"dts", (String)queueName);
                    DtsMQueueDefManager.start(conumer);
                }
            }
            finally {
                latch.countDown();
                ThreadLifeCycleManager.end();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

