/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dts.DtsMsgSender;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.check.address.DestinationCheckerFactory;
import kd.bos.dts.check.consistence.Checker;
import kd.bos.dts.config.DtsConfig;
import kd.bos.dts.config.change.DtsConfigChangeNotifier;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.init.AddressStatus;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.init.MonitorRecorder;
import kd.bos.dts.log.DateUtil;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.log.DtsStatusType;
import kd.bos.dts.log.StoreageHelper;
import kd.bos.dts.oplog.Oplog;
import kd.bos.dts.oplog.Status;
import kd.bos.dts.retry.RetryService;
import kd.bos.dts.retry.RetryStroage;
import kd.bos.dts.service.DtsMQueueDefManager;
import kd.bos.dts.service.DtsService;
import kd.bos.dts.syncconfig.SyncConfigCompareInfo;
import kd.bos.dts.syncconfig.SyncConfigInfo;
import kd.bos.id.IDService;
import kd.bos.instance.Instance;
import kd.bos.orm.datasync.ConfigureItemStatus;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DestinationType;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.agent.UpgraderStatus;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ThreadLocals;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;

public class DtsConfigMonitor {
    private static AtomicBoolean hasInited = new AtomicBoolean(false);
    public static final String DTS_CONFIG_CHANGE_KEY = "dts_config_change_key";
    public static final String DTS_CONSISTENCE_CHECK_BEGIN = "dts.consistence.check.begin";
    public static final String DTS_CONSISTENCE_CHECK_INTERVAL = "dts.consistence.check.interval";

    public static DtsConfigMonitor get() {
        return DtsConfigMonitorHolder.instance;
    }

    protected static void init() {
        if (hasInited.compareAndSet(false, true)) {
            ScheduledExecutorService es = Executors.newScheduledThreadPool(3);
            DtsConfigMonitor dcm = DtsConfigMonitor.get();
            es.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
                Thread.currentThread().setName("DTSMonitor-Compare");
                if (DtsUtils.dtsEnable() && DtsService.isMaster()) {
                    dcm.runCompareTask();
                }
                ThreadLocals.release();
            }), 1L, 120L, TimeUnit.SECONDS);
            es.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
                Thread.currentThread().setName("DTSMonitor-CheckDestination");
                if (DtsUtils.dtsEnable() && DtsService.isMaster()) {
                    dcm.runCheckDestinationTask();
                }
                ThreadLocals.release();
            }), 10L, 30L, TimeUnit.SECONDS);
            es.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
                Thread.currentThread().setName("DTSMonitor-CheckRetryService");
                if (DtsUtils.dtsEnable() && DtsService.isMaster()) {
                    dcm.runCheckRetryServiceTask();
                }
                ThreadLocals.release();
            }), 10L, 60L, TimeUnit.SECONDS);
            es = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "DTSMonitor-CheckAndModifyTask-");
                    t.setDaemon(true);
                    return t;
                }
            });
            int delayInitialCheck = Integer.getInteger(DTS_CONSISTENCE_CHECK_BEGIN, 1);
            if (delayInitialCheck < 0) {
                delayInitialCheck = Integer.MAX_VALUE;
            }
            es.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
                if (DtsUtils.dtsEnable() && DtsService.isMaster()) {
                    dcm.runCheckAndModifyTask();
                }
            }), delayInitialCheck, Integer.getInteger(DTS_CONSISTENCE_CHECK_INTERVAL, 4).intValue(), TimeUnit.HOURS);
            es = Executors.newScheduledThreadPool(1);
            long period = 86400000L;
            long initDelay = DateUtil.getTimeMillis((String)"03:00:00") - System.currentTimeMillis();
            initDelay = initDelay > 0L ? initDelay : period + initDelay;
            es.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
                Thread.currentThread().setName("DTSMonitor-DeleteDtsMonitorLog");
                if (DtsUtils.dtsEnable() && DtsService.isMaster()) {
                    dcm.runDeleteDtsMonitorLogTask();
                }
                ThreadLocals.release();
            }), initDelay, period, TimeUnit.MILLISECONDS);
        }
    }

    private void runCheckAndModifyTask() {
        List<Account> accounts = DtsUtils.getAllAccountsOfCurrentEnv();
        long clusterStart = System.currentTimeMillis();
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            if (UpgraderStatus.status.isUpgradering()) {
                return;
            }
            try {
                if (DtsAccountPower.isAccountDtsEnable()) {
                    long accountStart = System.currentTimeMillis();
                    Map<String, SyncConfigInfo> configs = DtsSnapConfigDao.instance.getConfigItems();
                    configs.forEach((k, v) -> {
                        if (ConfigureItemStatus.working != v.getStatus()) {
                            return;
                        }
                        DestinationTransRule rule = new DestinationTransRule();
                        rule.setBusinessType(v.getBusinessType());
                        rule.setRegion(v.getRegion());
                        rule.setType(DestinationType.getType((String)v.getDestinationtype()));
                        rule.setMappingrule(v.getMappingrule());
                        DestinationRuleConfig destinationConfig = DestinationRuleConfig.get((String)v.getEntitynumber(), (DestinationTransRule)rule);
                        try {
                            Map<String, Object> result = Checker.checkAndRepair(destinationConfig);
                            StringBuilder checkResult = new StringBuilder();
                            checkResult.append(destinationConfig.getShowName()).append("[").append(result).append("],");
                            ExceptionLogger.log(DtsConfigMonitor.class, (String)String.format("%s DTS CheckAndModifyTask result: %s ", account.getAccountId(), checkResult.toString()));
                        }
                        catch (Exception e) {
                            ExceptionLogger.log(DtsConfigMonitor.class, (String)String.format("%s run DTS CheckAndModifyTask error ", destinationConfig.getShowName()), (Throwable)e);
                        }
                    });
                    ExceptionLogger.log(DtsConfigMonitor.class, (String)String.format("%s DTS CheckAndModifyTask spends %s ms", account.getAccountId(), System.currentTimeMillis() - accountStart));
                }
            }
            catch (Exception e) {
                ExceptionLogger.log(DtsConfigMonitor.class, (String)"run DTS CheckAndModifyTask error ", (Throwable)e);
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        });
        ExceptionLogger.log(DtsConfigMonitor.class, (String)String.format("Cluster %s`s DTS CheckAndModifyTask spends %s ms", Instance.getClusterName(), System.currentTimeMillis() - clusterStart));
    }

    public void runCompareTask() {
        List<Account> accounts = DtsUtils.getAllAccountsOfCurrentEnv();
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            if (UpgraderStatus.status.isUpgradering()) {
                return;
            }
            try {
                this.queryAndSend();
            }
            catch (Exception e) {
                ExceptionLogger.log(DtsConfigMonitor.class, (String)"DtsConfigMonitor error ", (Throwable)e);
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        });
    }

    public void runCheckRetryServiceTask() {
        List<Account> accounts = DtsUtils.getAllAccountsOfCurrentEnv();
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            if (UpgraderStatus.status.isUpgradering()) {
                return;
            }
            try {
                if (DtsAccountPower.isAccountDtsEnable()) {
                    RetryService.checkAndModify();
                }
            }
            catch (Exception e) {
                ExceptionLogger.log(DtsConfigMonitor.class, (String)"DtsConfigMonitor runCheckRetryServiceTask error ", (Throwable)e);
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        });
    }

    public void runCheckDestinationTask() {
        List<Account> accounts = DtsUtils.getAllAccountsOfCurrentEnv();
        accounts.forEach(account -> {
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            if (UpgraderStatus.status.isUpgradering()) {
                return;
            }
            try {
                this.checkDestination();
            }
            catch (Exception e) {
                ExceptionLogger.log(DtsConfigMonitor.class, (String)"DtsConfigMonitor checkDestination error ", (Throwable)e);
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        });
    }

    private void checkDestination() {
        if (DtsAccountPower.isAccountDtsEnable()) {
            List<AddressStatus> ls = DtsSnapConfigDao.instance.getDestinationInfoForWork();
            ls.forEach(v -> {
                String destype = v.getDestinationtype();
                String region = v.getRegion();
                String status = v.getStatus();
                if (ConfigureItemStatus.working.getName().equals(status)) {
                    if (!DestinationCheckerFactory.getChecker(destype, region).isAvailable()) {
                        DtsSnapConfigDao.instance.suspend(destype, region);
                    }
                } else if (ConfigureItemStatus.suspend.getName().equals(status) && DestinationCheckerFactory.getChecker(destype, region).isAvailable()) {
                    List<Long> notResume = RetryStroage.get().queryRetryList();
                    DtsSnapConfigDao.instance.resume(destype, region, notResume);
                }
            });
        }
    }

    @Deprecated
    public void queryAndSend() {
        this.queryAndSend(new MonitorRecorder(){

            @Override
            public void recordFind(List<SyncConfigCompareInfo> configList) {
            }

            @Override
            public void recordSend(SyncConfigCompareInfo configInfo) {
            }

            @Override
            public void recordNotAvailable(SyncConfigCompareInfo configInfo) {
            }
        });
    }

    public void queryAndSend(String entityNumber, String destType, String region, String mappingRule) {
        this.queryAndSend(new MonitorRecorder(){

            @Override
            public void recordFind(List<SyncConfigCompareInfo> configList) {
            }

            @Override
            public void recordSend(SyncConfigCompareInfo configInfo) {
            }

            @Override
            public void recordNotAvailable(SyncConfigCompareInfo configInfo) {
            }
        }, entityNumber, destType, region, mappingRule);
    }

    public void doInitConfig() {
        MonitorRecorder recorder = new MonitorRecorder(){

            @Override
            public void recordFind(List<SyncConfigCompareInfo> configList) {
                ArrayList ls = new ArrayList();
                configList.forEach(v -> ls.add(v.toString()));
                DtsStatusReporterFactory.get().confInitFoundReport(ls, DtsStatusType.CONFIG_CHANGED_NOT_FOUND);
            }

            @Override
            public void recordSend(SyncConfigCompareInfo configInfo) {
                DtsStatusReporterFactory.get().confInitReport(configInfo.getDestinationEntityConfig(), configInfo.getOperationStates().getName(), DtsStatusType.CONFIG_SENDED);
            }

            @Override
            public void recordNotAvailable(SyncConfigCompareInfo configInfo) {
                DtsStatusReporterFactory.get().confInitReport(configInfo.getDestinationEntityConfig(), configInfo.getOperationStates().getName(), DtsStatusType.CONFIG_NOT_SEND_UNAVAIABLE);
            }
        };
        ThreadPools.executeOnce((String)"DtsConfigMonitor", () -> this.queryAndSend(recorder));
    }

    @Deprecated
    public void queryAndSend(MonitorRecorder recorder) {
        if (DtsAccountPower.isAccountDtsEnable()) {
            List<SyncConfigCompareInfo> compareList = DtsSnapConfigDao.instance.getDtsConfigChanged();
            compareList.forEach(v -> {
                v.setInnerId(String.valueOf(IDService.get().genLongId()));
                if (DestinationCheckerFactory.getChecker(v.getDestinationtype(), v.getRegion()).isAvailable()) {
                    this.sendConfig((SyncConfigCompareInfo)v);
                    recorder.recordSend((SyncConfigCompareInfo)v);
                } else {
                    recorder.recordNotAvailable((SyncConfigCompareInfo)v);
                    String msg = "DTS destination address not avaiable for  " + v;
                    ExceptionLogger.log(DtsConfigMonitor.class, (String)msg);
                    RuntimeException e = new RuntimeException(msg);
                    Oplog.get().error((SyncConfigCompareInfo)v, ExceptionLogger.getStack((Throwable)e));
                    DtsStatusReporterFactory.get().confInitReportError((Exception)e, v.getDestinationEntityConfig());
                }
            });
            if (compareList.size() == 0) {
                recorder.recordFind(compareList);
            }
        }
    }

    public void queryAndSend(MonitorRecorder recorder, String entityNumber, String destType, String region, String mappingRule) {
        if (DtsAccountPower.isAccountDtsEnable()) {
            List<SyncConfigCompareInfo> compareList = DtsSnapConfigDao.instance.getDtsConfigChanged(entityNumber, destType, region, mappingRule);
            compareList.forEach(v -> {
                v.setInnerId(String.valueOf(IDService.get().genLongId()));
                if (DestinationCheckerFactory.getChecker(v.getDestinationtype(), v.getRegion()).isAvailable()) {
                    this.sendConfig((SyncConfigCompareInfo)v);
                    recorder.recordSend((SyncConfigCompareInfo)v);
                } else {
                    recorder.recordNotAvailable((SyncConfigCompareInfo)v);
                    String msg = "DTS destination address not avaiable for  " + v;
                    ExceptionLogger.log(DtsConfigMonitor.class, (String)msg);
                    RuntimeException e = new RuntimeException(msg);
                    Oplog.get().error((SyncConfigCompareInfo)v, ExceptionLogger.getStack((Throwable)e));
                    DtsStatusReporterFactory.get().confInitReportError((Exception)e, v.getDestinationEntityConfig());
                }
            });
            if (compareList.size() == 0) {
                recorder.recordFind(compareList);
            }
        }
    }

    private void sendConfig(SyncConfigCompareInfo v) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(DTS_CONFIG_CHANGE_KEY, v);
        String businessType = v.getBusinessType();
        String entityNumber = v.getEntitynumber();
        if (!DtsMQueueDefManager.initQueueIfAbsent(businessType, entityNumber)) {
            String appid = DtsConfig.get().getAppidByEntityNumber(entityNumber);
            DtsConfigChangeNotifier.fireDtsConfigChangeNotify(businessType, entityNumber, appid);
        }
        DtsMsgSender.send("dts", "kd.bos.service.dts.init_config_queue", m);
        Oplog.get().recordTask(v, Status.submit_sync_task, v.getInnerId());
    }

    private void runDeleteDtsMonitorLogTask() {
        List<Account> accounts = DtsUtils.getAllAccountsOfCurrentEnv();
        accounts.forEach(account -> {
            block10: {
                ThreadLifeCycleManager.start();
                RequestContext context = RequestContext.create();
                context.setAccountId(account.getAccountId());
                context.setTenantId(account.getTenantId());
                try {
                    if (!DtsAccountPower.isAccountDtsEnable()) break block10;
                    if (!Boolean.getBoolean("dts.log.keep")) {
                        try {
                            DtsSnapConfigDao.instance.deleteDataSyncLog();
                        }
                        catch (Exception e) {
                            ExceptionLogger.error(DtsConfigMonitor.class, (String)"dts delDtsMonitorLog error", (Throwable)e);
                        }
                    }
                    String logDay = System.getProperty("dts.monitor.log.day", "7");
                    Date beforeDay = DateUtil.addDay((Date)DateUtil.getNowDayBegin(), (int)(-Integer.parseInt(logDay)));
                    DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{StoreageHelper.indexName});
                    RangeQueryBuilder queryBuilder = QueryBuilders.rangeQuery((String)"dts_timestap").lte((Object)beforeDay.getTime());
                    request.setQuery((QueryBuilder)queryBuilder);
                    long delNum = 0L;
                    try {
                        BulkByScrollResponse response = StoreageHelper.getRestClient().deleteByQuery(request, RequestOptions.DEFAULT);
                        delNum = response.getStatus().getDeleted();
                        ExceptionLogger.log(DtsConfigMonitor.class, (String)"dts delete monitor log time:{}, num={}:", (Object[])new Object[]{new Date(), delNum});
                    }
                    catch (IOException e) {
                        ExceptionLogger.error(DtsConfigMonitor.class, (String)"dts delDtsMonitorLog error", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    ExceptionLogger.log(DtsConfigMonitor.class, (String)"DtsConfigMonitor runDeleteDtsMonitorLogTask error ", (Throwable)e);
                }
                finally {
                    ThreadLifeCycleManager.end();
                }
            }
        });
    }

    private static class DtsConfigMonitorHolder {
        private static DtsConfigMonitor instance = new DtsConfigMonitor();

        private DtsConfigMonitorHolder() {
        }
    }
}

