/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.config.UpgraderColumnAppid;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.init.table.TableConfigEntryInitTable;
import kd.bos.dts.init.table.TableConfigInitTable;
import kd.bos.dts.init.table.TableInitialize;
import kd.bos.dts.service.DtsAccountPowerAllNodesListenerImpl;
import kd.bos.dts.service.DtsMQueueDefManager;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.DtsAccountPowerListener;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.datasync.agent.UpgraderColumnParenttable;
import kd.bos.orm.datasync.agent.UpgraderStatus;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.WebPortUtil;

public class DtsInitService
implements Service {
    private boolean started;

    public String getName() {
        return "DtsInitService";
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        try {
            if (DtsUtils.dtsEnable()) {
                DtsAccountPower.registerListener((DtsAccountPowerListener)new DtsAccountPowerAllNodesListenerImpl());
                this.dtsInitTask();
            }
        }
        catch (Exception e) {
            ExceptionLogger.log(DtsInitService.class, (String)"DtsInitService error ", (Throwable)e);
        }
        finally {
            this.started = true;
        }
    }

    private void dtsInitTask() {
        DistributeSessionlessCache cuationStore = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dts");
        DtsMQueueDefManager.initStaitcDtsQueueDefs();
        List<Account> accounts = DtsUtils.getAllAccountsOfCurrentEnv();
        ExecutorService es = Executors.newFixedThreadPool(8);
        CountDownLatch latch = new CountDownLatch(accounts.size());
        accounts.forEach(account -> es.submit(() -> {
            try {
                DtsAccountPower.setAccountDtsPower((Account)account);
                if (Instance.isWebMserviceInOne() || !WebPortUtil.isWebNode()) {
                    ThreadLifeCycleManager.start();
                    RequestContext context = RequestContext.create();
                    context.setAccountId(account.getAccountId());
                    context.setTenantId(account.getTenantId());
                    if (DtsAccountPower.isAccountDtsEnable()) {
                        DtsMQueueDefManager.initCurrentDtsQueueDefs();
                        String key = this.getAccountKey(account.getAccountId());
                        if (!cuationStore.contains(key)) {
                            TableInitialize.initTable();
                            cuationStore.put(key, (Object)key, 2592000);
                        }
                        if (!UpgraderColumnAppid.isUpgraded()) {
                            new TableConfigInitTable().initTable();
                        }
                        if (!UpgraderColumnParenttable.isUpgraded()) {
                            new TableConfigEntryInitTable().initTable();
                        }
                        if (!UpgraderStatus.status.isUpgradering()) {
                            DataSyncConfigCache.get().initConfig();
                        }
                    }
                }
            }
            catch (Exception e) {
                ExceptionLogger.log(DtsInitService.class, (String)"dtsInitTableTask error ", (Throwable)e);
            }
            finally {
                latch.countDown();
                ThreadLifeCycleManager.end();
            }
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ExceptionLogger.log(DtsInitService.class, (String)"dtsInitTableTask await error ", (Throwable)e);
        }
        es.shutdown();
    }

    private String getAccountKey(String accountId) {
        return "dts-" + Instance.getClusterName() + "-" + accountId;
    }

    public void stop() {
    }
}

