/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.SyncDataConsumer;
import kd.bos.dts.config.DtsConfig;
import kd.bos.dts.init.DtsConfigureConsumer;
import kd.bos.dts.retry.RetryConsumer;
import kd.bos.dts.service.DtsService;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.RabbitConsumer;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.orm.datasync.DtsAccountPower;

public class DtsMQueueDefManager {
    private static Map<String, String> hasInitMap = new ConcurrentHashMap<String, String>();
    private static Set<String> dtsQueueNames = new HashSet<String>();
    private static Set<String> dtsAppids = new HashSet<String>();
    private static Map<String, Set<String>> appidDtsQueueNames = new ConcurrentHashMap<String, Set<String>>();

    public static void initCurrentDtsQueueDefs() {
        if (DtsUtils.isDtsQueueSplit()) {
            DtsConfig.get().initDtsConfig();
            Set<String> splitKeys = DtsConfig.get().getDtsQueueSplitKeys();
            for (String splitKey : splitKeys) {
                DtsMQueueDefManager.initDtsQueueDefs(splitKey);
            }
        }
    }

    public static void initStaitcDtsQueueDefs() {
        if (!DtsUtils.isDtsQueueSplit()) {
            String splitKey = "";
            DtsMQueueDefManager.initDtsQueueDefs(splitKey);
        }
    }

    public static void initDtsQueueDefs(String splitKey) {
        hasInitMap.computeIfAbsent(splitKey, k -> {
            List<QueueDef> queueDefs = DtsMQueueDefManager.getQueueDefs(splitKey);
            for (QueueDef qdef : queueDefs) {
                QueueManager.add((String)"dts", (QueueDef)qdef);
                String queueName = qdef.getName();
                dtsQueueNames.add(queueName);
                if (!DtsUtils.dtsBizRunEnable()) continue;
                String appid = DtsUtils.getAppidBuQueueName(queueName);
                Set<String> dtsQueueNames = appidDtsQueueNames.get(appid);
                if (dtsQueueNames == null) {
                    dtsQueueNames = new HashSet<String>(2);
                    dtsAppids.add(appid);
                    appidDtsQueueNames.put(appid, dtsQueueNames);
                }
                dtsQueueNames.add(queueName);
            }
            return k;
        });
    }

    public static boolean initQueueIfAbsent(String businessType, String entityNumber) {
        if (!DtsAccountPower.isAccountDtsEnable()) {
            return true;
        }
        String splitKey = DtsConfig.get().getDtsQueueSplitKey(businessType, entityNumber);
        boolean hasInit = hasInitMap.containsKey(splitKey);
        if (!hasInit) {
            DtsConfig.get().addDtsQueyeSplitKey(splitKey);
            DtsMQueueDefManager.initDtsQueueDefs(splitKey);
        }
        return hasInit;
    }

    public static Set<String> getDtsAppids() {
        return dtsAppids;
    }

    public static Set<String> getAppidDtsQueueNames(String appid) {
        return Collections.unmodifiableSet(appidDtsQueueNames.get(appid));
    }

    public static Set<String> getDtsQueueNames() {
        return Collections.unmodifiableSet(dtsQueueNames);
    }

    public static Set<String> getCurrentDtsQueueNames() {
        HashSet<String> queueNames = new HashSet<String>();
        if (DtsUtils.isDtsQueueSplit()) {
            Set<String> splitKeys = DtsConfig.get().getDtsQueueSplitKeys();
            for (String splitKey : splitKeys) {
                List<QueueDef> queueDefs = DtsMQueueDefManager.getQueueDefs(splitKey);
                for (QueueDef qdef : queueDefs) {
                    queueNames.add(qdef.getName());
                }
            }
        }
        return Collections.unmodifiableSet(queueNames);
    }

    public static Set<String> getDtsQueueNames(String businessType, String entityNumber) {
        HashSet<String> queueNames = new HashSet<String>(3);
        String splitKey = DtsConfig.get().getDtsQueueSplitKey(businessType, entityNumber);
        List<QueueDef> queueDefs = DtsMQueueDefManager.getQueueDefs(splitKey);
        for (QueueDef qdef : queueDefs) {
            QueueManager.add((String)"dts", (QueueDef)qdef);
            String queueName = qdef.getName();
            queueNames.add(queueName);
        }
        return queueNames;
    }

    private static List<QueueDef> getQueueDefs(String splitName) {
        ArrayList<QueueDef> queueDefs = new ArrayList<QueueDef>();
        queueDefs.add(DtsMQueueDefManager.getQueueDef("kd.bos.service.dts.sync_data_queue" + splitName, SyncDataConsumer.class.getName(), 1));
        queueDefs.add(DtsMQueueDefManager.getQueueDef("kd.bos.service.dts.sync_data_waitinitqueue" + splitName, SyncDataConsumer.class.getName(), 1));
        queueDefs.add(DtsMQueueDefManager.getQueueDef("kd.bos.service.dts.init_config_queue" + splitName, DtsConfigureConsumer.class.getName(), 2));
        queueDefs.add(DtsMQueueDefManager.getQueueDef("kd.bos.service.dts.sync_data_retry_queue" + splitName, RetryConsumer.class.getName(), 1));
        return queueDefs;
    }

    private static QueueDef getQueueDef(String queueName, String className, int concurrency) {
        QueueDef queue = new QueueDef();
        if (DtsUtils.dtsBizRunEnable()) {
            String appid = DtsUtils.getAppidBuQueueName(queueName);
            queue.setAppid(appid);
        } else {
            queue.setAppid(DtsService.DTS_RUNNING_APPID);
        }
        queue.setLazyInit(true);
        queue.setName(queueName);
        ArrayList<ConsumerDef> consumerDefs = new ArrayList<ConsumerDef>();
        ConsumerDef consumerDef = new ConsumerDef();
        consumerDef.setAutoAck(false);
        consumerDef.setConcurrency(concurrency);
        consumerDef.setClassName(className);
        consumerDefs.add(consumerDef);
        queue.setConsumers(consumerDefs);
        queue.setDuration(true);
        return queue;
    }

    public static void start(Consumer consumer) {
        RabbitConsumer rabbitConsumer;
        if (!(!(consumer instanceof RabbitConsumer) || (rabbitConsumer = (RabbitConsumer)consumer).getChannel() != null && rabbitConsumer.getChannel().isOpen() && rabbitConsumer.getChannel().getConnection().isOpen())) {
            rabbitConsumer.setChannel(ChannelFactory.getChannel((String)"dts"));
        }
        consumer.start();
    }

    public static void stop(Consumer consumer) {
        consumer.$$stop();
    }

    public static void addQueueNamesForAccountEnable(String appid, Set<String> queueNames) {
        if (DtsUtils.dtsBizRunEnable()) {
            Set<String> dtsQueueNames = appidDtsQueueNames.get(appid);
            if (dtsQueueNames == null) {
                dtsQueueNames = new HashSet<String>(2);
                dtsAppids.add(appid);
                appidDtsQueueNames.put(appid, dtsQueueNames);
            }
            dtsQueueNames.addAll(queueNames);
        }
        dtsQueueNames.addAll(queueNames);
    }

    public static void removeQueueNamesForAccountDisenable(String appid, Set<String> queueNames) {
        if (DtsUtils.dtsBizRunEnable()) {
            Set<String> dtsQueueNames = appidDtsQueueNames.get(appid);
            dtsQueueNames.removeAll(queueNames);
            if (dtsQueueNames.isEmpty()) {
                dtsAppids.remove(appid);
            }
        }
        dtsQueueNames.removeAll(queueNames);
    }
}

