/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.config.DtsConfig;
import kd.bos.dts.config.change.DtsConfigChangeNotifier;
import kd.bos.dts.controller.ConsumerControllerListener;
import kd.bos.dts.service.DtsConfigMonitor;
import kd.bos.dts.service.DtsMQueueDefManager;
import kd.bos.dts.service.DtsUpgradeService;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.ConfigForInitConsumer;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.util.AppUtils;

public class DtsService
implements Service {
    private static final Log logger = LogFactory.getLog(DtsService.class);
    private boolean started;
    private static Map<String, Elector> electors = new ConcurrentHashMap<String, Elector>(2);
    public static final String DTS_RUNNING_APPID = System.getProperty("dts.running.appid", "bos");

    public String getName() {
        return "DtsService";
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        try {
            if (DtsUtils.dtsEnable()) {
                DtsConfigMonitor.init();
                if (DtsUtils.dtsBizRunEnable()) {
                    Set<String> dtsAppids = DtsMQueueDefManager.getDtsAppids();
                    dtsAppids.forEach(appid -> {
                        if (this.isCurrentNodeDeployApp((String)appid)) {
                            String dtsElectName = "dts-" + appid;
                            Elector elector = ElectFactory.getElector((String)dtsElectName);
                            electors.put((String)appid, elector);
                            elector.registerListener((ElectorListener)new ConsumerControllerListener((String)appid));
                            elector.start();
                        }
                    });
                }
                if (this.isCurrentNodeDeployApp(DTS_RUNNING_APPID)) {
                    Elector elector = ElectFactory.getElector((String)"dts");
                    electors.put("dts", elector);
                    elector.registerListener((ElectorListener)new ConsumerControllerListener("dts"));
                    elector.start();
                    DtsUpgradeService.start();
                }
                DtsConfigChangeNotifier.registerListener(li -> {
                    CountDownLatch latch = new CountDownLatch(1);
                    ThreadPools.executeOnce((String)"DtsConfigChangeListener-Change", () -> {
                        try {
                            String appid;
                            ThreadLifeCycleManager.start();
                            RequestContext context = RequestContext.create();
                            context.setAccountId(li.getAccountId());
                            context.setTenantId(li.getTenantId());
                            String businessType = li.getBusinessType();
                            String entityNumber = li.getEntityName();
                            DtsMQueueDefManager.initQueueIfAbsent(businessType, entityNumber);
                            if (DtsUtils.dtsBizRunEnable() && !electors.containsKey(appid = DtsConfig.get().getAppidByEntityNumber(entityNumber)) && this.isCurrentNodeDeployApp(appid)) {
                                String dtsElectName = "dts-" + appid;
                                Elector elector = ElectFactory.getElector((String)dtsElectName);
                                electors.put(appid, elector);
                                elector.registerListener((ElectorListener)new ConsumerControllerListener(appid));
                                elector.start();
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
            }
        }
        finally {
            this.started = true;
        }
    }

    private boolean isCurrentNodeDeployApp(String string) {
        if (!ConfigForInitConsumer.isConsumerRegionEnable((String)"dts")) {
            return false;
        }
        if (Instance.isAppSplit()) {
            String[] appids = Instance.getAppIds();
            if (appids == null) {
                return false;
            }
            for (String appid : appids) {
                if (!appid.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        String[] deployAppIds = Instance.getAppIds();
        boolean isCurrentDeployAlone = AppUtils.isDeployAloneApps((String[])deployAppIds);
        if (isCurrentDeployAlone) {
            for (String deployAppId : deployAppIds) {
                if (!string.equals(deployAppId)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void stop() {
    }

    public static boolean isMaster() {
        return DtsService.isAppidMaster("dts");
    }

    public static boolean isAppidMaster(String appid) {
        Elector elector = electors.get(appid);
        return elector == null ? false : elector.isMaster();
    }

    public static String getMaster() {
        return ElectFactory.getElector((String)"dts").getMaster().getInstanceId();
    }

    public static String getMasterByAppId(String appid) {
        if (appid.equalsIgnoreCase(DTS_RUNNING_APPID)) {
            appid = "dts";
        }
        String instanceId = ElectFactory.getElector((String)appid).getMaster().getInstanceId();
        StringBuilder stringBuilder = new StringBuilder("kd.bos.dts.service.DtsService.getMasterByAppId:");
        stringBuilder.append("appid#").append(appid);
        stringBuilder.append(",instanceId#").append(instanceId);
        logger.debug(stringBuilder.toString());
        return instanceId;
    }
}

