/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.lock.Lock;
import kd.bos.dts.lock.LockFactory;
import kd.bos.dts.service.DtsService;
import kd.bos.dts.service.upgrade.Upgrader;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;

public class DtsUpgradeService {
    private static Map<String, Boolean> upgradeMap = new ConcurrentHashMap<String, Boolean>();

    public static void start() {
        ThreadPools.executeOnce((String)"DtsUpgradeService", () -> {
            List<Account> accounts = DtsUtils.getAllAccountsOfCurrentEnv();
            while (true) {
                try {
                    int hour = Calendar.getInstance().get(11);
                    if (hour > 3 || hour < 2 || !DtsService.isMaster() || !"true".equals(System.getProperty("dts.upgrade.enable", "true"))) continue;
                    if (accounts.size() == upgradeMap.size()) {
                        return;
                    }
                    DtsUpgradeService.upgrade(accounts);
                    continue;
                }
                catch (Exception e) {
                    ExceptionLogger.log(DtsUpgradeService.class, (String)"run DtsUpgradeService error ", (Throwable)e);
                    continue;
                }
                finally {
                    LockSupport.parkNanos(600000000000L);
                    continue;
                }
                break;
            }
        });
    }

    private static void upgrade(List<Account> accounts) {
        accounts.forEach(account -> {
            if (!DtsService.isMaster()) {
                return;
            }
            ThreadLifeCycleManager.start();
            RequestContext context = RequestContext.create();
            context.setAccountId(account.getAccountId());
            context.setTenantId(account.getTenantId());
            try {
                if (Upgrader.hasFinish()) {
                    DtsUpgradeService.setUpgraded(account);
                    return;
                }
                String lockKey = "dts_upgrade_" + account.getAccountId();
                try (TXHandle h = TX.required((String)"dts_upgrade_");
                     Lock lock = LockFactory.create(lockKey);){
                    if (lock.lock()) {
                        if (Upgrader.hasFinish()) {
                            DtsUpgradeService.setUpgraded(account);
                            return;
                        }
                        Upgrader.upgrade();
                        DtsUpgradeService.setUpgraded(account);
                    }
                }
            }
            finally {
                ThreadLifeCycleManager.end();
            }
        });
    }

    private static void setUpgraded(Account account) {
        upgradeMap.put(account.getAccountId(), true);
    }
}

