/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service.upgrade;

import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.service.upgrade.Upgrade;
import kd.bos.id.IDService;
import kd.bos.orm.datasync.DtsThreadContext;

public abstract class AbstractUpgrade
implements Upgrade {
    private String inserSql = "insert into t_dts_upgrade(ftaskid,fdesc,fid) values(?,?,?)";

    @Override
    public void execute() {
        try (TXHandle tx = TX.requiresNew();
             DtsThreadContext dtsContext = DtsThreadContext.create();){
            String[] tasksqls;
            for (String tasksql : tasksqls = this.getTaskSql()) {
                DB.execute((DBRoute)DBRoute.basedata, (String)tasksql);
            }
            this.completeTask();
        }
        catch (Exception e) {
            ExceptionLogger.error(AbstractUpgrade.class, (String)"dts upgrade error", (Throwable)e);
        }
    }

    protected void completeTask() {
        String desc = this.getDescription();
        if (desc == null || desc.length() == 0) {
            desc = this.getClass().getName();
        }
        DB.execute((DBRoute)DBRoute.basedata, (String)this.inserSql, (Object[])new Object[]{this.getUpgradeTaskId(), desc, IDService.get().genLongId()});
        ExceptionLogger.log(this.getClass(), (String)("dtsUpgradefor: " + desc + " account: " + RequestContext.get().getAccountId()));
    }

    public abstract String[] getTaskSql();
}

