/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.exception.ExceptionLogger;
import kd.bos.dts.service.upgrade.AbstractUpgrade;
import kd.bos.orm.datasync.DtsThreadContext;

public class DeleteRepeatConfigData
extends AbstractUpgrade {
    private static final String[] sql = new String[]{"delete from T_DTS_DATASYNCCONFIG where FID in (select a.FID from (select FID from T_DTS_DATASYNCCONFIG group by FENTITYNUMBER,FDESTINATIONTYPE,FREGION ,fmappingrule having count(FID) > 1) a) and FID not in ( select b.id from (select max(FID) id from T_DTS_DATASYNCCONFIG group by FENTITYNUMBER,FDESTINATIONTYPE,FREGION,fmappingrule having count(FID)>1) b)"};

    @Override
    public String getUpgradeTaskId() {
        return "DeleteRepeatConfigData";
    }

    @Override
    public String getDescription() {
        return "Delete Repeat Config Data";
    }

    @Override
    public String[] getTaskSql() {
        return sql;
    }

    @Override
    public void execute() {
        ArrayList deleteIds = new ArrayList();
        try (DataSet ds = DB.queryDataSet((String)"query", (DBRoute)DBRoute.basedata, (String)"select fdestinationtype, fentitynumber,fmappingrule,fregion,fid from T_DTS_DATASYNCCONFIG order by fid desc");){
            HashSet onlyKey = new HashSet();
            ds.forEach(v -> {
                StringBuilder sb = new StringBuilder();
                sb.append(v.getString("fdestinationtype"));
                sb.append(v.getString("fentitynumber"));
                sb.append(v.getString("fmappingrule"));
                sb.append(v.getString("fregion"));
                if (!onlyKey.add(sb.toString())) {
                    deleteIds.add(v.getLong("fid"));
                }
            });
        }
        try {
            var3_4 = null;
            try (TXHandle tx = TX.requiresNew();
                 DtsThreadContext dtsContext = DtsThreadContext.create();){
                if (!deleteIds.isEmpty()) {
                    String sql = "delete from  T_DTS_DATASYNCCONFIG where ";
                    SqlBuilder builder = new SqlBuilder();
                    builder.append(sql, new Object[0]);
                    builder.appendIn("fid", deleteIds);
                    DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)builder);
                }
                this.completeTask();
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            ExceptionLogger.error(AbstractUpgrade.class, (String)"dts upgrade error", (Throwable)e);
        }
    }
}

