/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dts.service.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.service.upgrade.AlterConfigMappingFiledTo300;
import kd.bos.dts.service.upgrade.AlterSnaphotMappingFiledTo300;
import kd.bos.dts.service.upgrade.CreateDtsConfigUniqeIndex;
import kd.bos.dts.service.upgrade.DeleteRepeatConfigData;
import kd.bos.dts.service.upgrade.DropDtsConfigUniqeIndex;
import kd.bos.dts.service.upgrade.Upgrade;
import kd.bos.orm.datasync.agent.UpgraderStatus;

public class Upgrader {
    private static List<Upgrade> allUpgraders = new ArrayList<Upgrade>();
    private static Map<String, Boolean> initedMap;

    private static Set<String> getAllTaskId() {
        HashSet<String> taskids = new HashSet<String>();
        allUpgraders.forEach(v -> taskids.add(v.getUpgradeTaskId()));
        return taskids;
    }

    public static synchronized void upgrade() {
        Set<String> taskid = Upgrader.getUnfinishTask();
        if (taskid.isEmpty()) {
            return;
        }
        try {
            UpgraderStatus.status.begin();
            LockSupport.parkNanos(3000000000L);
            allUpgraders.forEach(updater -> {
                if (taskid.contains(updater.getUpgradeTaskId())) {
                    updater.execute();
                }
            });
        }
        finally {
            UpgraderStatus.status.end();
        }
    }

    private static Set<String> getUnfinishTask() {
        HashSet ls = new HashSet(8);
        try (DataSet ds = DB.queryDataSet((String)"getUnfinishTask", (DBRoute)DBRoute.basedata, (String)"select ftaskid from t_dts_upgrade");){
            ds.forEach(v -> {
                String id = v.getString("ftaskid");
                ls.add(id);
            });
        }
        Set<String> all = Upgrader.getAllTaskId();
        all.removeAll(ls);
        return all;
    }

    private static boolean hasTableInit() {
        return initedMap.getOrDefault(Upgrader.genKey(), false);
    }

    private static void initTable() {
        initedMap.computeIfAbsent(Upgrader.genKey(), k -> Boolean.TRUE);
    }

    private static String genKey() {
        String preKey = "xxx";
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            return rc.getAccountId();
        }
        return preKey;
    }

    public static boolean hasFinish() {
        if (!Upgrader.hasTableInit() && !DB.exitsTable((DBRoute)DBRoute.basedata, (String)"t_dts_upgrade")) {
            DB.execute((DBRoute)DBRoute.basedata, (String)"create table t_dts_upgrade(ftaskid NVARCHAR(66) not null,fdesc NVARCHAR(256),FID BIGINT DEFAULT 0 NOT NULL) ", (Object[])new Object[0]);
            DB.execute((DBRoute)DBRoute.basedata, (String)"EXEC P_ALTERPK 'PK_DTS_UPGRADE', 'T_DTS_UPGRADE', 'FID', '1'", (Object[])new Object[0]);
        }
        Upgrader.initTable();
        return Upgrader.getUnfinishTask().isEmpty();
    }

    static {
        allUpgraders.add(new DeleteRepeatConfigData());
        allUpgraders.add(new DropDtsConfigUniqeIndex());
        allUpgraders.add(new CreateDtsConfigUniqeIndex());
        allUpgraders.add(new AlterConfigMappingFiledTo300());
        allUpgraders.add(new AlterSnaphotMappingFiledTo300());
        initedMap = new ConcurrentHashMap<String, Boolean>(4);
    }
}

