/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.impl;

import com.google.common.base.Charsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.encrypt.lax.EncryptLax;
import kd.bos.util.AESUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@Deprecated
public class EncryptLaxImpl
implements EncryptLax {
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_RSA = "RSA/ECB/PKCS1Padding";
    private static final String CIPHER_AES = "AES/ECB/PKCS5Padding";

    public byte[] MD_5_Hash(byte[] buf, int offset, int length) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(buf, offset, length);
        return md.digest();
    }

    public byte[] addMD_5(byte[] md5Byte, byte[] bodyByte) {
        int length = bodyByte.length + md5Byte.length;
        byte[] resutlByte = new byte[length];
        for (int i = 0; i < length; ++i) {
            resutlByte[i] = i < md5Byte.length ? md5Byte[i] : bodyByte[i - md5Byte.length];
        }
        return resutlByte;
    }

    public void getKeyIV(String encryptKey, byte[] key, byte[] iv) {
        byte[] buf = Base64.decodeBase64((String)encryptKey);
        System.arraycopy(buf, 0, key, 0, key.length);
        System.arraycopy(buf, 8, iv, 0, iv.length);
    }

    public String encryptWithEncodeBase64UTF8(String orginalContent, Key key) {
        try {
            return Base64.encodeBase64URLSafeString((byte[])EncryptLaxImpl.encryptLarger(orginalContent.getBytes("UTF-8"), key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String encryptPSW(String strSrc) {
        String strEncode = null;
        byte[] btKey = new byte[strSrc.getBytes(Charsets.UTF_8).length + 1];
        System.arraycopy(strSrc.getBytes(Charsets.UTF_8), 0, btKey, 0, strSrc.getBytes(Charsets.UTF_8).length);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(btKey);
            byte[] btDigest = md.digest();
            strEncode = Base64.encodeBase64String((byte[])btDigest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return strEncode;
    }

    public byte[] decrypt(byte[] data, byte[] key) {
        try {
            Key k = this.toKey(key);
            Cipher cipher = Cipher.getInstance(CIPHER_AES);
            cipher.init(2, k);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decrypt(String dataString, String keyString) {
        try {
            String returnValue = null;
            if (StringUtils.isEmpty((String)dataString) || StringUtils.isEmpty((String)keyString)) {
                return returnValue;
            }
            byte[] key = AESUtils.getBase64DecodeKey((String)keyString);
            byte[] data = Base64.decodeBase64((String)dataString);
            return new String(this.decrypt(data, key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(byte[] data, byte[] key) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Key k = this.toKey(key);
            Cipher cipher = Cipher.getInstance(CIPHER_AES);
            cipher.init(1, k);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String encrypt(String dataString, String keyString) {
        try {
            if (StringUtils.isEmpty((String)dataString) || StringUtils.isEmpty((String)keyString)) {
                return null;
            }
            byte[] data = dataString.getBytes(Charsets.UTF_8);
            byte[] key = AESUtils.getBase64DecodeKey((String)keyString);
            return Base64.encodeBase64String((byte[])this.encrypt(data, key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Key toKey(byte[] key) {
        SecretKeySpec secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
        return secretKey;
    }

    private static byte[] encryptLarger(byte[] data, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher rsa = Cipher.getInstance(CIPHER_RSA);
        rsa.init(1, key);
        SecureRandom random = new SecureRandom();
        byte[] secretKey = new byte[16];
        random.nextBytes(secretKey);
        Cipher aes = Cipher.getInstance(CIPHER_AES);
        SecretKeySpec k = new SecretKeySpec(secretKey, KEY_ALGORITHM);
        aes.init(1, k);
        byte[] ciphedKey = rsa.doFinal(secretKey);
        byte[] ciphedData = aes.doFinal(data);
        byte[] result = new byte[128 + ciphedData.length];
        System.arraycopy(ciphedKey, 0, result, 0, 128);
        System.arraycopy(ciphedData, 0, result, 128, ciphedData.length);
        return result;
    }
}

