/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils.oauth2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.login.utils.OAuth2Encrypter;
import kd.bos.login.utils.oauth2.Oauth2Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class OAuth2EncrypterImpl
implements OAuth2Encrypter {
    private static Logger logger = LoggerFactory.getLogger(OAuth2EncrypterImpl.class);
    private static final String UTF_8 = "UTF-8";
    private static final Oauth2Base64 BASE64 = new Oauth2Base64();
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String DEFAULT_SIGNATURE_METHOD = "HMAC-SHA1";
    private static String characterEncoding = "UTF-8";

    public String generateAuthorizationHeader(String consKey, String consSecret, String signMethod, long timestamp, String numberOnce, float versionNum, String oauthToken1, String oauthTokenSecret1, String verifier1, String urlStr, Map<String, Object> parameters1, String reqType) throws URISyntaxException, IOException, GeneralSecurityException {
        if (StringUtils.isEmpty((String)consKey)) {
            throw new IllegalArgumentException("consKey is null or empty!");
        }
        if (StringUtils.isEmpty((String)consSecret)) {
            throw new IllegalArgumentException("consSecret is null or empty!");
        }
        if (null == numberOnce) {
            throw new IllegalArgumentException("numberOnce is null!");
        }
        if (StringUtils.isEmpty((String)urlStr)) {
            throw new IllegalArgumentException("urlStr is null or empty!");
        }
        if (StringUtils.isEmpty((String)reqType)) {
            throw new IllegalArgumentException("requestType is null or empty!");
        }
        if (StringUtils.isEmpty((String)signMethod)) {
            signMethod = DEFAULT_SIGNATURE_METHOD;
        }
        LinkedHashMap<String, String> oauthHeaderParamsMap = new LinkedHashMap<String, String>();
        oauthHeaderParamsMap.put("oauth_consumer_key", consKey);
        oauthHeaderParamsMap.put("oauth_signature_method", signMethod);
        oauthHeaderParamsMap.put("oauth_timestamp", String.valueOf(timestamp));
        oauthHeaderParamsMap.put("oauth_nonce", numberOnce);
        oauthHeaderParamsMap.put("oauth_version", String.valueOf(versionNum));
        if (StringUtils.isNotEmpty((String)oauthToken1)) {
            if (StringUtils.isEmpty((String)oauthTokenSecret1)) {
                throw new IllegalArgumentException("oauthTokenSecret1 is null or empty!");
            }
            oauthHeaderParamsMap.put("oauth_token", oauthToken1);
        }
        if (StringUtils.isNotEmpty((String)verifier1)) {
            oauthHeaderParamsMap.put("oauth_verifier", verifier1);
        }
        HashMap<String, Object> signatureBaseParams = new HashMap<String, Object>(oauthHeaderParamsMap);
        if (null != parameters1 && !parameters1.isEmpty()) {
            signatureBaseParams.putAll(parameters1);
        }
        this.parseGetParameters(urlStr, signatureBaseParams);
        String oauthBaseStr = this.getBaseString(reqType, urlStr, signatureBaseParams);
        String signatureStr = this.base64Encode(this.computeSignature(consSecret, oauthTokenSecret1, oauthBaseStr));
        oauthHeaderParamsMap.put("oauth_signature", signatureStr);
        String authorizationValue = "OAuth " + this.encodeParameters(oauthHeaderParamsMap, ",", true);
        return authorizationValue;
    }

    private void parseGetParameters(String urlStr, Map<String, Object> signatureBaseParams) {
        int queryStart = urlStr.indexOf(63);
        if (-1 != queryStart) {
            String[] queryStrs = urlStr.substring(queryStart + 1).split("&");
            try {
                for (String query : queryStrs) {
                    String[] splits = query.split("=");
                    if (splits.length == 2) {
                        signatureBaseParams.put(URLDecoder.decode(splits[0], UTF_8), URLDecoder.decode(splits[1], UTF_8));
                        continue;
                    }
                    signatureBaseParams.put(URLDecoder.decode(splits[0], UTF_8), "");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private String getBaseString(String reqType, String urlStr, Map<String, Object> parameters) throws URISyntaxException, IOException {
        return OAuth2EncrypterImpl.percentEncode(reqType.toUpperCase()) + '&' + OAuth2EncrypterImpl.percentEncode(OAuth2EncrypterImpl.normalizeUrl(urlStr)) + '&' + OAuth2EncrypterImpl.percentEncode(this.normalizeParameters(parameters));
    }

    private static String normalizeUrl(String urlStr) throws URISyntaxException {
        String path;
        int index;
        boolean dropPort;
        URI uri = new URI(urlStr);
        String schemeStr = uri.getScheme().toLowerCase();
        String authorityStr = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = schemeStr.equals("http") && uri.getPort() == 80 || schemeStr.equals("https") && uri.getPort() == 443;
        if (dropPort && (index = authorityStr.lastIndexOf(58)) >= 0) {
            authorityStr = authorityStr.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return schemeStr + "://" + authorityStr + path;
    }

    private byte[] computeSignature(String consumerSecret, String tokenSecret, String baseString) throws GeneralSecurityException, UnsupportedEncodingException {
        String keyString = OAuth2EncrypterImpl.percentEncode(consumerSecret) + '&' + OAuth2EncrypterImpl.percentEncode(tokenSecret);
        byte[] keyBytes = keyString.getBytes(UTF_8);
        SecretKeySpec key = new SecretKeySpec(keyBytes, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(key);
        byte[] text = baseString.getBytes(UTF_8);
        return mac.doFinal(text);
    }

    public static String percentEncode(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        try {
            return URLEncoder.encode(s, UTF_8).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    private String base64Encode(byte[] b) {
        byte[] b2 = BASE64.encode(b);
        try {
            return new String(b2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.toString());
            return null;
        }
    }

    private String encodeParameters(Map<String, String> signatureBaseParams, String splitter, boolean quot) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : signatureBaseParams.entrySet()) {
            String key = entry.getKey();
            if (buf.length() != 0) {
                if (quot) {
                    buf.append("\"");
                }
                buf.append(splitter);
            }
            buf.append(OAuth2EncrypterImpl.percentEncode(key)).append("=");
            if (quot) {
                buf.append("\"");
            }
            buf.append(OAuth2EncrypterImpl.percentEncode(signatureBaseParams.get(key)));
        }
        if (buf.length() != 0 && quot) {
            buf.append("\"");
        }
        return buf.toString();
    }

    private String normalizeParameters(Map<String, Object> parametersMap) throws IOException {
        if (null == parametersMap || parametersMap.isEmpty()) {
            return "";
        }
        ArrayList<ComparableParameter> p = new ArrayList<ComparableParameter>(parametersMap.size());
        for (Map.Entry<String, Object> parameter : parametersMap.entrySet()) {
            if ("oauth_signature".equals(parameter.getKey())) continue;
            p.add(new ComparableParameter(parameter));
        }
        Collections.sort(p);
        return OAuth2EncrypterImpl.formEncode(OAuth2EncrypterImpl.getParameters(p));
    }

    public static String formEncode(Iterable<? extends Map.Entry<String, Object>> parametersEntry) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        OAuth2EncrypterImpl.formEncode(parametersEntry, b);
        return OAuth2EncrypterImpl.decodeCharacters(b.toByteArray());
    }

    public static String decodeCharacters(byte[] fromBytes) {
        if (StringUtils.isNotEmpty((String)characterEncoding)) {
            try {
                return new String(fromBytes, characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.toString());
            }
        }
        return null;
    }

    public static void formEncode(Iterable<? extends Map.Entry<String, Object>> parametersEntry, OutputStream into) throws IOException {
        if (parametersEntry != null) {
            boolean first = true;
            for (Map.Entry<String, Object> entry : parametersEntry) {
                if (first) {
                    first = false;
                } else {
                    into.write(38);
                }
                into.write(OAuth2EncrypterImpl.encodeCharacters(OAuth2EncrypterImpl.percentEncode(OAuth2EncrypterImpl.toString(entry.getKey()))));
                into.write(61);
                into.write(OAuth2EncrypterImpl.encodeCharacters(OAuth2EncrypterImpl.percentEncode(OAuth2EncrypterImpl.toString(entry.getValue()))));
            }
        }
    }

    public static byte[] encodeCharacters(String fromByte) {
        if (characterEncoding != null) {
            try {
                return fromByte.getBytes(characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.toString());
            }
        }
        return null;
    }

    private static final String toString(Object from) {
        return from == null ? null : from.toString();
    }

    private static List<Map.Entry<String, Object>> getParameters(Collection<ComparableParameter> parametersCollect) {
        if (parametersCollect == null) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(parametersCollect.size());
        for (ComparableParameter parameter : parametersCollect) {
            list.add(parameter.valueEntry);
        }
        return list;
    }

    private static class ComparableParameter
    implements Comparable<ComparableParameter> {
        final Map.Entry<String, Object> valueEntry;
        private final String keyStr;

        ComparableParameter(Map.Entry<String, Object> valueEntry) {
            this.valueEntry = valueEntry;
            String n = ComparableParameter.toString(valueEntry.getKey());
            String v = ComparableParameter.toString(valueEntry.getValue());
            this.keyStr = OAuth2EncrypterImpl.percentEncode(n) + ' ' + OAuth2EncrypterImpl.percentEncode(v);
        }

        private static String toString(Object from) {
            return from == null ? null : from.toString();
        }

        @Override
        public int compareTo(ComparableParameter that) {
            return this.keyStr.compareTo(that.keyStr);
        }

        public String toString() {
            return this.keyStr;
        }
    }
}

