/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.lifecycle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.lifecycle.ReleaseResource;
import kd.sdk.lifecycle.ReleaseResources;

public final class ReleaseResourceUtil {
    private static final Map<Method, List<String>> resourcesMap = new ConcurrentHashMap<Method, List<String>>();

    private ReleaseResourceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResources(Method method) {
        List<String> list = resourcesMap.get(method);
        if (list == null) {
            Method method2 = method;
            synchronized (method2) {
                list = resourcesMap.get(method);
                if (list == null) {
                    list = ReleaseResourceUtil.getResources0(method);
                    resourcesMap.put(method, list);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> getResources0(Method method) {
        ReleaseResource r = method.getAnnotation(ReleaseResource.class);
        ReleaseResources l = method.getAnnotation(ReleaseResources.class);
        if (r == null && l == null) {
            ArrayList interfaces = new ArrayList(4);
            ReleaseResourceUtil.collectAllInterfaces(method.getDeclaringClass(), interfaces);
            if (interfaces.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> ret = new ArrayList<String>(4);
            for (Class clazz : interfaces) {
                try {
                    Method m = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    List<String> list = ReleaseResourceUtil.getResources(m);
                    if (list.isEmpty()) continue;
                    if (ret.isEmpty()) {
                        ret.addAll(list);
                        continue;
                    }
                    for (String res : list) {
                        if (ret.contains(res)) continue;
                        ret.add(res);
                    }
                }
                catch (NoSuchMethodException m) {
                }
            }
            return Collections.unmodifiableList(ret);
        }
        ArrayList<String> ret = new ArrayList<String>(4);
        if (r != null) {
            ret.add(r.value());
        }
        if (l != null) {
            void var6_11;
            ReleaseResource[] releaseResourceArray = l.value();
            int n = releaseResourceArray.length;
            boolean bl = false;
            while (var6_11 < n) {
                ReleaseResource item = releaseResourceArray[var6_11];
                String v = item.value();
                if (!ret.contains(v)) {
                    ret.add(v);
                }
                ++var6_11;
            }
        }
        return Collections.unmodifiableList(ret);
    }

    private static void collectAllInterfaces(Class<?> clazz, List<Class<?>> interfaces) {
        for (Class<?> cls : clazz.getInterfaces()) {
            if (interfaces.contains(cls)) continue;
            interfaces.add(cls);
        }
        if (clazz.getSuperclass() != null) {
            ReleaseResourceUtil.collectAllInterfaces(clazz.getSuperclass(), interfaces);
        }
    }
}

