/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.annotation.SdkSPI;
import kd.sdk.spi.SPIConfigurationException;

@SdkPublic
public final class ServiceLoader {
    private ServiceLoader() {
    }

    public static <T> List<T> load(Class<T> spiCls) throws SPIConfigurationException {
        SdkSPI spi = spiCls.getAnnotation(SdkSPI.class);
        return ServiceLoader.load(spiCls, spi != null && spi.single());
    }

    public static <T> T loadSingle(Class<T> spiCls) throws SPIConfigurationException {
        return ServiceLoader.load(spiCls, true).get(0);
    }

    private static <T> List<T> load(Class<T> spiCls, boolean single) {
        ArrayList<T> ret = new ArrayList<T>();
        java.util.ServiceLoader<T> sl = java.util.ServiceLoader.load(spiCls);
        Iterator<T> iter = sl.iterator();
        while (iter.hasNext()) {
            ret.add(iter.next());
        }
        if (single) {
            if (ret.isEmpty()) {
                throw new SPIConfigurationException("Not found spi implement: " + spiCls.getName());
            }
            if (ret.size() > 1) {
                throw new SPIConfigurationException("Found multi-spi implements: " + spiCls.getName() + "->" + ret);
            }
        }
        return Collections.unmodifiableList(ret);
    }
}

