/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.atomicincr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.atomicincr.AtomicIncrService;
import kd.bos.atomicincr.config.AtomicIncrConfig;
import kd.bos.atomicincr.impl.DBAtomicIncrServiceImpl;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkPublic
public class AtomicIncrement {
    private final String module;
    private static final ConcurrentHashMap<String, AtomicIncrement> atomicIncrementMap = new ConcurrentHashMap();
    public static volatile AtomicIncrService atomicIncrService = null;
    Logger logger = LoggerFactory.getLogger(AtomicIncrement.class);

    private AtomicIncrement(String module) {
        this.module = module;
        atomicIncrService = new DBAtomicIncrServiceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtomicIncrement getInstance(String module) {
        AtomicIncrement instance = atomicIncrementMap.get(module);
        if (instance == null) {
            ConcurrentHashMap<String, AtomicIncrement> concurrentHashMap = atomicIncrementMap;
            synchronized (concurrentHashMap) {
                instance = atomicIncrementMap.get(module);
                if (instance == null) {
                    instance = new AtomicIncrement(module);
                    atomicIncrementMap.put(module, instance);
                }
            }
        }
        return instance;
    }

    public boolean exist(String key) {
        this.verifyKey(key);
        key = this.generateKey(key);
        return atomicIncrService.exist(key);
    }

    public Long get(String key) {
        this.verifyKey(key);
        key = this.generateKey(key);
        return atomicIncrService.get(key);
    }

    public Map<String, Long> batchGet(Set<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return new HashMap<String, Long>();
        }
        HashSet<String> newKeys = new HashSet<String>(keys.size());
        for (String key : keys) {
            this.verifyKey(key);
            newKeys.add(this.generateKey(key));
        }
        Map<String, Long> map = atomicIncrService.batchGet(newKeys);
        HashMap<String, Long> resMap = new HashMap<String, Long>(keys.size());
        for (String key : keys) {
            resMap.put(key, map.getOrDefault(this.generateKey(key), null));
        }
        return resMap;
    }

    public void setnx(String key, long initValue) {
        block11: {
            this.verifyKey(key);
            if (!this.exist(key)) {
                DLock dLock = null;
                try {
                    dLock = DLock.create((String)("AtomicIncrement_init_" + key));
                    Integer timeout = AtomicIncrConfig.ATOMIC_INCR_LOCK_TIMEOUT.getInteger(RequestContext.get().getTenantId());
                    if (dLock.tryLock((long)timeout.intValue())) {
                        if (this.exist(key)) {
                            return;
                        }
                        key = this.generateKey(key);
                        atomicIncrService.insert(key, initValue);
                        break block11;
                    }
                    throw new KDException(BosErrorCode.atomicIncr_setnxError, new Object[]{"AtomicIncrement setnx trylock failed! key: " + key});
                }
                catch (KDException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.atomicIncr_setnxError, new Object[]{"AtomicIncrement setnx error: " + e.getMessage(), e});
                }
                finally {
                    if (dLock != null) {
                        dLock.unlock();
                    }
                }
            }
        }
    }

    public Long decr(String key) {
        return this.decr(key, 1);
    }

    public Long decr(String key, int step) {
        this.verifyValue(step);
        this.verifyKey(key);
        this.setnx(key, 0L);
        step = -step;
        key = this.generateKey(key);
        Long decr = atomicIncrService.incr(key, Long.valueOf(step));
        if (decr == null) {
            String errormsg = String.format("atomic incr occur an error, key: %s, step: %s", key, (long)step);
            throw new KDException(BosErrorCode.bOS, new Object[]{errormsg});
        }
        return decr;
    }

    public Long incr(String key) {
        return this.incr(key, 1);
    }

    public Long incr(String key, int step) {
        this.verifyValue(step);
        this.verifyKey(key);
        this.setnx(key, 0L);
        key = this.generateKey(key);
        Long incr = atomicIncrService.incr(key, Long.valueOf(step));
        if (incr == null) {
            String errormsg = String.format("atomic incr occur an error, key: %s, step: %s", key, (long)step);
            throw new KDException(BosErrorCode.bOS, new Object[]{errormsg});
        }
        return incr;
    }

    public void del(String key) {
        this.verifyKey(key);
        key = this.generateKey(key);
        atomicIncrService.del(key);
    }

    public boolean compareAndSet(String key, long value) {
        block12: {
            this.verifyKey(key);
            if (value <= 0L) {
                throw new KDException(BosErrorCode.atomicIncr_invalidValue, new Object[]{"invalidvalue: " + value});
            }
            if (!this.exist(key)) {
                this.logger.info("not exist key: " + key);
                return false;
            }
            DLock dLock = null;
            try {
                dLock = DLock.create((String)("AtomicIncrement_compareAndSet_" + key));
                Integer timeout = AtomicIncrConfig.ATOMIC_INCR_LOCK_TIMEOUT.getInteger(RequestContext.get().getTenantId());
                if (dLock.tryLock((long)timeout.intValue())) {
                    Long curValue = this.get(key);
                    if (curValue == null || curValue >= value) {
                        this.logger.info("curValue is null or curValue greater than value");
                        boolean bl = false;
                        return bl;
                    }
                    key = this.generateKey(key);
                    atomicIncrService.set(key, value);
                    break block12;
                }
                throw new KDException(BosErrorCode.atomicIncr_setnxError, new Object[]{"AtomicIncrement compareAndSet trylock failed! key: " + key});
            }
            catch (KDException e) {
                throw e;
            }
            catch (Exception e) {
                String errormsg = String.format("compareAndSet occur an error, key: %s, value: %s", key, value);
                throw new KDException(BosErrorCode.bOS, errormsg, (Throwable)e);
            }
            finally {
                if (dLock != null) {
                    dLock.unlock();
                }
            }
        }
        return true;
    }

    private void verifyKey(String key) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)key.trim())) {
            throw new KDException(BosErrorCode.atomicIncr_invalidKey, new Object[]{"invalidkey: " + key});
        }
    }

    private void verifyValue(long value) {
        if (value <= 0L) {
            throw new KDException(BosErrorCode.atomicIncr_invalidValue, new Object[]{"invalidvalue: " + value});
        }
    }

    private String generateKey(String key) {
        return key + "_" + this.module;
    }
}

