/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.atomicincr.impl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.atomicincr.AtomicIncrService;
import kd.bos.atomicincr.config.AtomicIncrConfig;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkInternal
public class DBAtomicIncrServiceImpl
implements AtomicIncrService {
    static Logger logger = LoggerFactory.getLogger(DBAtomicIncrServiceImpl.class);
    private static final String TABLE_NAME = "t_bos_atomicincr_generator";
    private static final String FUNCTION_NAME = "bos_atomicincr_incr";
    private AtomicBoolean supportFunction = new AtomicBoolean(true);
    private static final String DLOCK_PREFIX = "bos_atomicincr_";
    private static final String KEY_UPGRADE_DLOCK = "atomic.upgrade.dlock";

    @Override
    public boolean exist(String key) {
        String selectSql = String.format("select fid from %s where fkey = ?", TABLE_NAME);
        Long fid = (Long)DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])new Object[]{key}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return null;
        });
        return fid != null;
    }

    @Override
    public void insert(String key, Long initValue) {
        String insertSql = String.format("insert into %s (fid, fkey, fvalue, fcreatorid, fmodifierid, fcreatetime, fmodifytime) values (?, ?, ?, ?, ?, now(), now())", TABLE_NAME);
        long currUserId = RequestContext.get().getCurrUserId();
        Object[] params = new Object[]{ID.genLongId(), key, initValue, currUserId, currUserId};
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.base, (String)insertSql, (Object[])params);
            }
            catch (Exception e) {
                String msg = String.format("DBAtomicIncrServiceImpl insert %s failed", key);
                txHandle.markRollback();
                throw this.logAndBuildKDException(msg, BosErrorCode.atomicIncr_insertError, e);
            }
        }
    }

    @Override
    public void set(String key, Long value) {
        String updateSQL = String.format("update %s set fvalue = ? where fkey = ?", TABLE_NAME);
        Object[] params = new Object[]{value, key};
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.base, (String)updateSQL, (Object[])params);
            }
            catch (Exception e) {
                String msg = String.format("DBAtomicIncrServiceImpl set %s failed", key);
                txHandle.markRollback();
                throw this.logAndBuildKDException(msg, BosErrorCode.atomicIncr_setError, e);
            }
        }
    }

    @Override
    public void del(String key) {
        String delSql = String.format("delete from %s where fkey = ?", TABLE_NAME);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                logger.info("DBAtomicIncrServiceImpl remove atomicincr key: " + key);
                DB.execute((DBRoute)DBRoute.basedata, (String)delSql, (Object[])new Object[]{key});
            }
            catch (Exception e) {
                String msg = String.format("DBAtomicIncrServiceImpl clear %s failed", key);
                txHandle.markRollback();
                throw this.logAndBuildKDException(msg, BosErrorCode.atomicIncr_delError, e);
            }
        }
    }

    @Override
    public Long get(String key) {
        String selectSql = String.format("select fvalue from %s where fkey = ?", TABLE_NAME);
        return (Long)DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])new Object[]{key}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return null;
        });
    }

    @Override
    public Map<String, Long> batchGet(Set<String> keys) {
        HashMap<String, Long> resMap = new HashMap<String, Long>();
        if (keys == null || keys.isEmpty()) {
            return resMap;
        }
        StringBuilder selectSql = new StringBuilder(String.format("select fkey, fvalue from %s where fkey in (", TABLE_NAME));
        ArrayList<String> params = new ArrayList<String>(keys.size());
        int index = 0;
        for (String key : keys) {
            selectSql.append("?");
            params.add(key);
            if (++index >= keys.size()) continue;
            selectSql.append(",");
        }
        selectSql.append(")");
        DB.query((DBRoute)DBRoute.basedata, (String)selectSql.toString(), (Object[])params.toArray(), resultSet -> {
            while (resultSet.next()) {
                String fkey = resultSet.getString("fkey");
                resMap.put(fkey, resultSet.getLong("fvalue"));
            }
            return null;
        });
        return resMap;
    }

    @Override
    public Long incr(String key, Long step) {
        return this.executeIncrFunction(key, step);
    }

    private Long executeIncrFunction(String key, Long step) {
        String tenantId = RequestContext.get().getTenantId();
        if (this.supportFunction.get() && AtomicIncrConfig.ATOMIC_INCR_EXECBY_FUNCTION.getBoolean(tenantId)) {
            Long res = this.incrByFunction(key, step);
            if (res == null) {
                res = this.incrBySQL(key, step);
            }
            return res;
        }
        return this.incrBySQL(key, step);
    }

    /*
     * Exception decompiling
     */
    private Long incrByFunction(String key, Long step) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Long incrBySQL(String key, Long step) {
        String updateSql = String.format("update %s set fvalue = ?, fmodifierid = ?, fmodifytime = now() where fkey = ? and fvalue = ? ", TABLE_NAME);
        String querySql = String.format("select fvalue from %s where fkey = ?", TABLE_NAME);
        long loopTime = 0L;
        DLock lock = DLock.create((String)(DLOCK_PREFIX + key));
        try {
            long next;
            Object tenantId;
            boolean casSuccess;
            do {
                tenantId = RequestContext.get().getTenantId();
                if (ConfigurationUtil.getBoolean((String)KEY_UPGRADE_DLOCK, (Boolean)false, (String)tenantId).booleanValue()) {
                    lock.lock();
                }
                if (ConfigurationUtil.getBoolean((String)"atomic.select.forupdate", (Boolean)false, (String)tenantId).booleanValue()) {
                    querySql = String.format("/*dialect*/ select fvalue from %s where fkey = ? FOR UPDATE", TABLE_NAME);
                }
                try (TXHandle txHandle = TX.requiresNew();){
                    Long current = (Long)DB.query((DBRoute)DBRoute.basedata, (String)querySql, (Object[])new Object[]{key}, rs -> {
                        if (rs.next()) {
                            return rs.getLong(1);
                        }
                        return null;
                    });
                    logger.info(String.format("key: %s, current: %s", key, current));
                    if (current == null) {
                        Long l = null;
                        return l;
                    }
                    try {
                        next = current + step;
                        Object[] params = new Object[]{next, RequestContext.get().getCurrUserId(), key, current};
                        casSuccess = DB.execute((DBRoute)DBRoute.basedata, (String)updateSql, (Object[])params);
                        ++loopTime;
                        txHandle.commit();
                    }
                    catch (Exception e) {
                        txHandle.markRollback();
                        throw e;
                    }
                }
                lock.unlock();
            } while (!casSuccess);
            if (loopTime > 10L) {
                logger.info(String.format("key: %s, looptime: %s", key, loopTime));
            }
            tenantId = next;
            return tenantId;
        }
        catch (Exception e) {
            String msg = String.format("DBAtomicIncrServiceImpl executeIncrFunction tx %s failed", key);
            throw this.logAndBuildKDException(msg, BosErrorCode.atomicIncr_incrBySqlError, e);
        }
        finally {
            lock.unlock();
        }
    }

    private KDException logAndBuildKDException(String errorMsg, ErrorCode errorCode, Exception e) {
        logger.warn(errorMsg);
        if (e instanceof KDException) {
            return (KDException)e;
        }
        return new KDException((Throwable)e, errorCode, new Object[]{errorMsg});
    }

    private static /* synthetic */ Long lambda$incrByFunction$4(ResultSet rs) throws Exception {
        if (rs.next()) {
            return rs.getLong(1);
        }
        return null;
    }

    private static /* synthetic */ Long lambda$incrByFunction$3(ResultSet rs) throws Exception {
        if (rs.next()) {
            return rs.getLong(1);
        }
        return null;
    }
}

