/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.serverscript.debug;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.mservice.serverscript.debug.DebugService;
import kd.bos.mservice.serverscript.debug.DebugStartParameter;
import kd.bos.script.ScriptClassInfo;
import kd.bos.script.ScriptInfo;
import kd.bos.script.debug.DebugCache;
import kd.bos.script.debug.DebugExecutor;
import kd.bos.script.debug.DebugManager;
import kd.bos.script.debug.DebugResult;
import kd.bos.script.jsengine.objects.LogMessage;
import kd.bos.util.resource.Resources;

public class DebugServiceImpl
implements DebugService {
    private DebugResult createNoDebugResult(String debugId) {
        DebugResult result = new DebugResult();
        result.setDebugId(debugId);
        result.setSuccess(false);
        result.setRunning(false);
        return result;
    }

    private DebugResult execute(String debugId, CMD cmd) {
        DebugManager dm = DebugManager.getDebugManager((String)debugId);
        if (dm == null) {
            return this.createNoDebugResult(debugId);
        }
        return cmd.execute(dm);
    }

    public DebugResult start(String debugId, Map<String, int[]> scriptBreakPointMap, String[] scriptWatchArray) {
        DebugStartParameter dsp = new DebugStartParameter();
        for (Map.Entry<String, int[]> entry : scriptBreakPointMap.entrySet()) {
            dsp.setBreakPoints(entry.getKey(), entry.getValue());
        }
        if (scriptWatchArray != null && scriptWatchArray.length > 0) {
            for (int i = 0; i < scriptWatchArray.length; ++i) {
                if (scriptWatchArray[i].indexOf(38) == -1) continue;
                dsp.addWatch(scriptWatchArray[i].split("&")[0], scriptWatchArray[i].split("&")[1]);
            }
        }
        return this.start(debugId, dsp);
    }

    public DebugResult start(String debugId, DebugStartParameter dsp) {
        try {
            DebugManager debugManager = DebugManager.waitForDebugManager((String)debugId);
            if (debugManager.isStarted()) {
                throw new IllegalArgumentException(Resources.getString((String)"\u8c03\u8bd5\u5df2\u7ecf\u542f\u52a8\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u542f\u52a8\u3002", (String)"DebugServiceImpl_0", (String)"mservice-serverscript", (Object[])new Object[0]));
            }
            for (Map.Entry entry : dsp.getBreakPointMap().entrySet()) {
                debugManager.setBreakPoint((String)entry.getKey(), (int[])entry.getValue());
            }
            for (Map.Entry entry : dsp.getWatchMap().entrySet()) {
                String scriptNumber = (String)entry.getKey();
                for (String exp : (String[])entry.getValue()) {
                    debugManager.addWatch(scriptNumber, exp);
                }
            }
            debugManager.skipAllBreakpoints(dsp.isSkipAllBreakPoint());
            return debugManager.startupThenGet();
        }
        catch (Exception e) {
            throw new RuntimeException("debug start failed:" + e.getMessage(), e);
        }
    }

    public DebugResult resume(String debugId) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().resume());
    }

    public DebugResult stop(String debugId) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().stop());
    }

    public DebugResult stepInto(String debugId) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().stepInto());
    }

    public DebugResult stepOver(String debugId) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().stepOver());
    }

    public DebugResult stepOut(String debugId) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().stepOut());
    }

    public DebugResult runToLine(String debugId, int line) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().runToLine(line));
    }

    public DebugResult getWatches(String debugId) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().getWatches());
    }

    public DebugResult getVariables(String debugId) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().getVariables());
    }

    public void updateBreakPoint(String debugId, Map<String, int[]> scriptBreakPointMap) {
        this.execute(debugId, dm -> {
            for (Map.Entry entry : scriptBreakPointMap.entrySet()) {
                dm.setBreakPoint((String)entry.getKey(), (int[])entry.getValue());
            }
            return null;
        });
    }

    public void updateScriptInfo(String debugId, ScriptInfo ... scriptInfos) {
        this.execute(debugId, dm -> {
            DebugCache cache = DebugManager.getDebugCache((String)debugId);
            for (ScriptInfo scriptInfo : scriptInfos) {
                cache.clearViewCache(scriptInfo.getName());
            }
            return null;
        });
    }

    public void updateAllBreakPoint(String debugId, Map<String, int[]> scriptBreakPointMap) {
        this.execute(debugId, dm -> {
            dm.clearAllBreakPoints();
            for (Map.Entry entry : scriptBreakPointMap.entrySet()) {
                dm.setBreakPoint((String)entry.getKey(), (int[])entry.getValue());
            }
            return null;
        });
    }

    public void addBreakPoint(String debugId, String scriptName, int[] breakPointLines) {
        this.execute(debugId, dm -> {
            dm.addBreakPoint(scriptName, breakPointLines);
            return null;
        });
    }

    public void removeBreakPoint(String debugId, String scriptName, int[] breakPointLines) {
        this.execute(debugId, dm -> {
            dm.removeBreakPoint(scriptName, breakPointLines);
            return null;
        });
    }

    public void removeAllBreakPoint(String debugId, String scriptName) {
        this.execute(debugId, dm -> {
            dm.setBreakPoint(scriptName, new int[0]);
            return null;
        });
    }

    public void removeAllBreakPoint(String debugId) {
        this.execute(debugId, dm -> {
            dm.clearAllBreakPoints();
            return null;
        });
    }

    public DebugResult evaluate(String debugId, String expression) {
        return this.execute(debugId, dm -> dm.getDebugExecutor().evaluate(expression));
    }

    public void updateWatch(String debugId, Map<String, String[]> scriptExpressionMap) {
        this.execute(debugId, dm -> {
            for (Map.Entry entry : scriptExpressionMap.entrySet()) {
                String scriptName = (String)entry.getKey();
                dm.clearWatches(scriptName);
                for (String exp : (String[])entry.getValue()) {
                    dm.addWatch(scriptName, exp);
                }
            }
            return null;
        });
    }

    public void updateAllWatch(String debugId, Map<String, String[]> scriptExpressionMap) {
        this.execute(debugId, dm -> {
            dm.clearAllWatches();
            for (Map.Entry entry : scriptExpressionMap.entrySet()) {
                String scriptName = (String)entry.getKey();
                for (String exp : (String[])entry.getValue()) {
                    dm.addWatch(scriptName, exp);
                }
            }
            return null;
        });
    }

    public void addWatch(String debugId, String scriptName, String expression) {
        this.execute(debugId, dm -> {
            dm.addWatch(scriptName, expression);
            return null;
        });
    }

    public void removeWatch(String debugId, String scriptName, String expression) {
        this.execute(debugId, dm -> {
            dm.removeWatch(scriptName, expression);
            return null;
        });
    }

    public void removeAllWatch(String debugId, String scriptName) {
        this.execute(debugId, dm -> {
            dm.clearWatches(scriptName);
            return null;
        });
    }

    public void removeAllWatch(String debugId) {
        this.execute(debugId, dm -> {
            dm.clearAllWatches();
            return null;
        });
    }

    public DebugResult getAtCurrentBreakPoint(String debugId) {
        DebugResult ret = this.execute(debugId, dm -> {
            DebugExecutor de = dm.getDebugExecutor();
            if (de == null) {
                DebugResult result = new DebugResult();
                result.setDebugId(debugId);
                return result;
            }
            return de.getAtBreakPoint(false);
        });
        return ret;
    }

    public void skipAllBreakPoints(String debugId, boolean skip) {
        DebugManager.getDebugManager((String)debugId).skipAllBreakpoints(skip);
    }

    public boolean keepAlive(String debugId) {
        return DebugManager.keepAlive((String)debugId);
    }

    public void exist(String debugId) {
        DebugManager.exit((String)debugId);
    }

    public Set<ScriptClassInfo> getDefinedClasses(String debugId) {
        DebugManager dm = DebugManager.getDebugManager((String)debugId);
        if (dm == null) {
            throw new RuntimeException(Resources.getString((String)"\u5c1a\u672a\u542f\u52a8\u8c03\u8bd5\u3002", (String)"DebugServiceImpl_1", (String)"mservice-serverscript", (Object[])new Object[0]));
        }
        return dm.getScriptExecutor().getContext().getDefinedClasses();
    }

    public List<LogMessage> getLogMessages(String debugId) {
        return DebugManager.getDebugManager((String)debugId).getLogMessages();
    }

    @FunctionalInterface
    private static interface CMD {
        public DebugResult execute(DebugManager var1);
    }
}

