/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.common.utils.UrlUtils;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.AbstractMethodConfig;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.MethodConfig;
import com.alibaba.dubbo.config.ModuleConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.support.Parameter;
import com.alibaba.dubbo.monitor.MonitorFactory;
import com.alibaba.dubbo.monitor.MonitorService;
import com.alibaba.dubbo.registry.RegistryFactory;
import com.alibaba.dubbo.registry.RegistryService;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.InvokerListener;
import com.alibaba.dubbo.rpc.ProxyFactory;
import com.alibaba.dubbo.rpc.cluster.Cluster;
import com.alibaba.dubbo.rpc.support.MockInvoker;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.mservice.rpc.dubbo.config.KDRegistryConfig;
import kd.bos.zk.ZKFactory;

public abstract class AbstractInterfaceConfig
extends AbstractMethodConfig {
    private static final long serialVersionUID = -1559314110797223229L;
    private static final String DUBBO = "dubbo";
    private static final String PROTOCOL = "protocol";
    protected String local;
    protected String stub;
    protected MonitorConfig monitor;
    protected String proxy;
    protected String cluster;
    protected String filter;
    protected String listener;
    protected String owner;
    protected Integer connections;
    protected String layer;
    protected ApplicationConfig application;
    protected ModuleConfig module;
    protected List<RegistryConfig> registries;
    private Integer callbacks;
    protected String onconnect;
    protected String ondisconnect;
    private String scope;

    protected void checkRegistry() {
        String address;
        if ((this.registries == null || this.registries.size() == 0) && (address = ConfigUtils.getProperty((String)"dubbo.registry.address")) != null && address.length() > 0) {
            String[] as;
            address = ZKFactory.getZkAddress((String)address);
            this.registries = new ArrayList<RegistryConfig>(8);
            for (String a : as = address.split("\\s*[|]+\\s*")) {
                RegistryConfig registryConfig = new RegistryConfig();
                registryConfig.setAddress(a);
                this.registries.add(registryConfig);
            }
        }
        if (this.registries == null || this.registries.size() == 0) {
            throw new IllegalStateException((((Object)((Object)this)).getClass().getSimpleName().startsWith("Reference") ? "No such any registry to refer service in consumer " : "No such any registry to export service in provider ") + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", Please add <dubbo:registry address=\"...\" /> to your spring config. If you want unregister, please set <dubbo:service registry=\"N/A\" />");
        }
        for (RegistryConfig registryConfig : this.registries) {
            AbstractInterfaceConfig.appendProperties((AbstractConfig)registryConfig);
        }
    }

    protected void checkApplication() {
        String applicationName;
        if (this.application == null && (applicationName = ConfigUtils.getProperty((String)"dubbo.application.name")) != null && applicationName.length() > 0) {
            this.application = new ApplicationConfig();
        }
        if (this.application == null) {
            throw new IllegalStateException("No such application config! Please add <dubbo:application name=\"...\" /> to your spring config.");
        }
        AbstractInterfaceConfig.appendProperties((AbstractConfig)this.application);
        String wait = ConfigUtils.getProperty((String)"dubbo.service.shutdown.wait");
        if (wait != null && wait.trim().length() > 0) {
            System.setProperty("dubbo.service.shutdown.wait", wait.trim());
        } else {
            wait = ConfigUtils.getProperty((String)"dubbo.service.shutdown.wait.seconds");
            if (wait != null && wait.trim().length() > 0) {
                System.setProperty("dubbo.service.shutdown.wait.seconds", wait.trim());
            }
        }
    }

    protected List<URL> loadRegistries(boolean provider) {
        this.checkRegistry();
        ArrayList<URL> registryList = new ArrayList<URL>();
        if (this.registries != null && this.registries.size() > 0) {
            for (RegistryConfig config : this.registries) {
                KDRegistryConfig kdconfig;
                String address = config.getAddress();
                if (address == null || address.length() == 0) {
                    address = "0.0.0.0";
                }
                String sysaddress = (kdconfig = (KDRegistryConfig)config).isFaultTolerant() ? System.getProperty("ha.zookeeper.backup") : System.getProperty("dubbo.registry.address");
                String user = null;
                String pass = null;
                if (sysaddress != null && sysaddress.length() > 0) {
                    user = config.getUsername();
                    pass = config.getPassword();
                }
                if (address == null || address.length() <= 0 || "N/A".equalsIgnoreCase(address)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                AbstractInterfaceConfig.appendParameters(map, (Object)this.application);
                AbstractInterfaceConfig.appendParameters(map, (Object)config);
                map.put("path", RegistryService.class.getName());
                map.put(DUBBO, Version.getVersion());
                map.put("timestamp", String.valueOf(System.currentTimeMillis()));
                if (ConfigUtils.getPid() > 0) {
                    map.put("pid", String.valueOf(ConfigUtils.getPid()));
                }
                if (!map.containsKey(PROTOCOL)) {
                    if (ExtensionLoader.getExtensionLoader(RegistryFactory.class).hasExtension("remote")) {
                        map.put(PROTOCOL, "remote");
                    } else {
                        map.put(PROTOCOL, DUBBO);
                    }
                }
                List<URL> urls = UrlUtils.parseURLs(address, map);
                for (URL url : urls) {
                    url = url.setUsername(user);
                    url = url.setPassword(pass);
                    url = url.addParameter("registry", url.getProtocol());
                    url = url.setProtocol("registry");
                    if ((!provider || !url.getParameter("register", true)) && (provider || !url.getParameter("subscribe", true))) continue;
                    registryList.add(url);
                }
            }
        }
        return registryList;
    }

    protected URL loadMonitor(URL registryURL) {
        if (this.monitor == null) {
            String monitorAddress = ConfigUtils.getProperty((String)"dubbo.monitor.address");
            String monitorProtocol = ConfigUtils.getProperty((String)"dubbo.monitor.protocol");
            if (monitorAddress != null && monitorAddress.length() > 0 || monitorProtocol != null && monitorProtocol.length() > 0) {
                this.monitor = new MonitorConfig();
            } else {
                return null;
            }
        }
        AbstractInterfaceConfig.appendProperties((AbstractConfig)this.monitor);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("interface", MonitorService.class.getName());
        map.put(DUBBO, Version.getVersion());
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        if (ConfigUtils.getPid() > 0) {
            map.put("pid", String.valueOf(ConfigUtils.getPid()));
        }
        AbstractInterfaceConfig.appendParameters(map, (Object)this.monitor);
        String address = this.monitor.getAddress();
        String sysaddress = System.getProperty("dubbo.monitor.address");
        if (sysaddress != null && sysaddress.length() > 0) {
            address = sysaddress;
        }
        if (ConfigUtils.isNotEmpty((String)address)) {
            if (!map.containsKey(PROTOCOL)) {
                if (ExtensionLoader.getExtensionLoader(MonitorFactory.class).hasExtension("logstat")) {
                    map.put(PROTOCOL, "logstat");
                } else {
                    map.put(PROTOCOL, DUBBO);
                }
            }
            return UrlUtils.parseURL(address, map);
        }
        if (registryURL != null && "registry".equals(this.monitor.getProtocol())) {
            return registryURL.setProtocol(DUBBO).addParameter(PROTOCOL, "registry").addParameterAndEncoded("refer", StringUtils.toQueryString(map));
        }
        return null;
    }

    protected void checkInterfaceAndMethods(Class<?> interfaceClass, List<MethodConfig> methods) {
        if (interfaceClass == null) {
            throw new IllegalStateException("interface not allow null!");
        }
        if (!interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        if (methods != null && methods.size() > 0) {
            for (MethodConfig methodBean : methods) {
                String methodName = methodBean.getName();
                if (methodName == null || methodName.length() == 0) {
                    throw new IllegalStateException("<dubbo:method> name attribute is required! Please check: <dubbo:service interface=\"" + interfaceClass.getName() + "\" ... ><dubbo:method name=\"\" ... /></<dubbo:reference>");
                }
                boolean hasMethod = false;
                for (Method method : interfaceClass.getMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    hasMethod = true;
                    break;
                }
                if (hasMethod) continue;
                throw new IllegalStateException("The interface " + interfaceClass.getName() + " not found method " + methodName);
            }
        }
    }

    protected void checkStubAndMock(Class<?> interfaceClass) {
        Class localClass;
        if (ConfigUtils.isNotEmpty((String)this.local)) {
            Class clazz = localClass = ConfigUtils.isDefault((String)this.local) ? ReflectUtils.forName((String)(interfaceClass.getName() + "Local")) : ReflectUtils.forName((String)this.local);
            if (!interfaceClass.isAssignableFrom(localClass)) {
                throw new IllegalStateException("The local implemention class " + localClass.getName() + " no implement interface: " + interfaceClass.getName());
            }
            try {
                ReflectUtils.findConstructor((Class)localClass, interfaceClass);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No such constructor \"public " + localClass.getSimpleName() + "(" + interfaceClass.getName() + ")\" in local implemention class " + localClass.getName());
            }
        }
        if (ConfigUtils.isNotEmpty((String)this.stub)) {
            Class clazz = localClass = ConfigUtils.isDefault((String)this.stub) ? ReflectUtils.forName((String)(interfaceClass.getName() + "Stub")) : ReflectUtils.forName((String)this.stub);
            if (!interfaceClass.isAssignableFrom(localClass)) {
                throw new IllegalStateException("The local implemention class " + localClass.getName() + " not implement interface:" + interfaceClass.getName());
            }
            try {
                ReflectUtils.findConstructor((Class)localClass, interfaceClass);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No such constructor \"public " + localClass.getSimpleName() + "(" + interfaceClass.getName() + ")\" in local implemention class " + localClass.getName());
            }
        }
        if (ConfigUtils.isNotEmpty((String)this.mock)) {
            Class mockClass;
            if (this.mock.startsWith("return ")) {
                String value = this.mock.substring("return ".length());
                try {
                    MockInvoker.parseMockValue((String)value);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Illegal mock json value in <dubbo:service ... mock=\"" + this.mock + "\" />");
                }
            }
            Class clazz = mockClass = ConfigUtils.isDefault((String)this.mock) ? ReflectUtils.forName((String)(interfaceClass.getName() + "Mock")) : ReflectUtils.forName((String)this.mock);
            if (!interfaceClass.isAssignableFrom(mockClass)) {
                throw new IllegalStateException("The mock implemention class " + mockClass.getName() + " not implement interface " + interfaceClass.getName());
            }
            try {
                mockClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No such empty constructor \"public " + mockClass.getSimpleName() + "()\" in mock implemention class " + mockClass.getName());
            }
        }
    }

    @Deprecated
    public String getLocal() {
        return this.local;
    }

    @Deprecated
    public void setLocal(String local) {
        AbstractInterfaceConfig.checkName((String)"local", (String)local);
        this.local = local;
    }

    @Deprecated
    public void setLocal(Boolean local) {
        if (local == null) {
            this.setLocal((String)null);
        } else {
            this.setLocal(String.valueOf(local));
        }
    }

    public String getStub() {
        return this.stub;
    }

    public void setStub(String stub) {
        AbstractInterfaceConfig.checkName((String)"stub", (String)stub);
        this.stub = stub;
    }

    public void setStub(Boolean stub) {
        if (this.local == null) {
            this.setStub((String)null);
        } else {
            this.setStub(String.valueOf(stub));
        }
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        AbstractInterfaceConfig.checkExtension(Cluster.class, (String)"cluster", (String)cluster);
        this.cluster = cluster;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        AbstractInterfaceConfig.checkExtension(ProxyFactory.class, (String)"proxy", (String)proxy);
        this.proxy = proxy;
    }

    public Integer getConnections() {
        return this.connections;
    }

    public void setConnections(Integer connections) {
        this.connections = connections;
    }

    @Parameter(key="reference.filter", append=true)
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        AbstractInterfaceConfig.checkMultiExtension(Filter.class, (String)"filter", (String)filter);
        this.filter = filter;
    }

    @Parameter(key="invoker.listener", append=true)
    public String getListener() {
        AbstractInterfaceConfig.checkMultiExtension(InvokerListener.class, (String)"listener", (String)this.listener);
        return this.listener;
    }

    public void setListener(String listener) {
        this.listener = listener;
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        AbstractInterfaceConfig.checkNameHasSymbol((String)"layer", (String)layer);
        this.layer = layer;
    }

    public ApplicationConfig getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationConfig application) {
        this.application = application;
    }

    public ModuleConfig getModule() {
        return this.module;
    }

    public void setModule(ModuleConfig module) {
        this.module = module;
    }

    public RegistryConfig getRegistry() {
        return this.registries == null || this.registries.size() == 0 ? null : this.registries.get(0);
    }

    public void setRegistry(RegistryConfig registry) {
        ArrayList<RegistryConfig> registries = new ArrayList<RegistryConfig>(1);
        registries.add(registry);
        this.registries = registries;
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<? extends RegistryConfig> registries) {
        this.registries = registries;
    }

    public MonitorConfig getMonitor() {
        return this.monitor;
    }

    public void setMonitor(MonitorConfig monitor) {
        this.monitor = monitor;
    }

    public void setMonitor(String monitor) {
        this.monitor = new MonitorConfig(monitor);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        AbstractInterfaceConfig.checkMultiName((String)"owner", (String)owner);
        this.owner = owner;
    }

    public void setCallbacks(Integer callbacks) {
        this.callbacks = callbacks;
    }

    public Integer getCallbacks() {
        return this.callbacks;
    }

    public String getOnconnect() {
        return this.onconnect;
    }

    public void setOnconnect(String onconnect) {
        this.onconnect = onconnect;
    }

    public String getOndisconnect() {
        return this.ondisconnect;
    }

    public void setOndisconnect(String ondisconnect) {
        this.ondisconnect = ondisconnect;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

