/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.kregistrycenter;

import com.alibaba.dubbo.common.URL;
import kd.bos.instance.Instance;
import kd.bos.mservice.kregistrycenter.BaseRegistrationInfo;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;

public class DubboRegistyInfoBuilder {
    private static final String baseDir = "/";
    private static final String[] anyCategroies = new String[]{"providers", "consumers", "routers", "configurators"};
    private URL registryUrl;

    public DubboRegistyInfoBuilder(URL registryUrl) {
        this.registryUrl = registryUrl;
    }

    public RegistrationInfo buildzk(URL url) {
        RegistrationInfo reg = new RegistrationInfo(url.getParameters());
        this.buildCommon((BaseRegistrationInfo)reg, url);
        reg.setServicePath(this.toServicePath(url));
        reg.categoryPath = this.toCategoryPath(url);
        reg.categoriesPath = this.toCategoriesPath(url);
        reg.fullUrl = url.toFullString();
        reg.setRootPath(this.registryUrl.getParameter("root"));
        reg.withRegistryUrl(this.registryUrl.getBackupAddress(), this.registryUrl.getUsername(), this.registryUrl.getPassword());
        return reg;
    }

    private void buildCommon(BaseRegistrationInfo reg, URL url) {
        reg.setProtocol(url.getProtocol());
        reg.setHost(url.getHost());
        reg.setPort(url.getPort());
        reg.setClusterName(Instance.getClusterName());
        reg.setEnable(true);
        reg.setGroup(url.getParameter("group"));
        reg.setServiceInterface(url.getServiceInterface());
        reg.setInstanceId(Instance.getInstanceId());
        reg.setEphemeral(url.getParameter("dynamic", true));
        reg.setIdentityString(url.toIdentityString());
        reg.setServiceKey(url.getServiceKey());
    }

    private String toServicePath(URL url) {
        String name = url.getServiceInterface();
        if ("*".equals(name)) {
            return baseDir;
        }
        String group = url.getParameter("group");
        if (group != null && group.length() > 0) {
            return baseDir + URL.encode(name) + baseDir + group;
        }
        return baseDir + URL.encode(name);
    }

    private String toCategoryPath(URL url) {
        return this.toServicePath(url) + baseDir + url.getParameter("category", "providers");
    }

    private String[] toCategoriesPath(URL url) {
        String[] categroies = "*".equals(url.getParameter("category")) ? anyCategroies : url.getParameter("category", new String[]{"providers"});
        String[] paths = new String[categroies.length];
        for (int i = 0; i < categroies.length; ++i) {
            paths[i] = this.toServicePath(url) + baseDir + categroies[i];
        }
        return paths;
    }
}

