/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.kregistrycenter;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.UrlUtils;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.kregistrycenter.DubboRegistyInfoBuilder;
import com.alibaba.dubbo.registry.support.FailbackRegistry;
import com.alibaba.dubbo.rpc.RpcException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import kd.bos.instance.Instance;
import kd.bos.mservice.kregistrycenter.CallNotify;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;
import kd.bos.mservice.kregistrycenter.spi.KRegistryCenter;
import kd.bos.mservice.kregistrycenter.spi.KRegistryCenterFactory;
import kd.bos.mservice.rpc.dubbo.rpc.RequestStatus;

public class KCommonRegistry
extends FailbackRegistry {
    private final KRegistryCenter registryCenter;
    private final URL registryUrl;
    private final DubboRegistyInfoBuilder builder;
    private final SecureRandom random = new SecureRandom();
    private AtomicLong index = new AtomicLong(this.random.nextInt(1000));
    private final int div = Integer.getInteger("dubbo.failregister.interval", 60) / 5;
    private volatile boolean hasPaused = false;
    private final ConcurrentMap<URL, ConcurrentMap<NotifyListener, CallNotify>> callBackListeners = new ConcurrentHashMap<URL, ConcurrentMap<NotifyListener, CallNotify>>();

    public KCommonRegistry(URL url) {
        super(url);
        this.registryUrl = url;
        this.builder = new DubboRegistyInfoBuilder(this.registryUrl);
        this.registryCenter = KRegistryCenterFactory.getRegistryCenter();
    }

    @Override
    protected void doRegister(URL url) {
        RegistrationInfo registrationInfoZK = this.builder.buildzk(url);
        this.registryCenter.doSaveRegister(registrationInfoZK);
        this.registryCenter.doNotifyConsumerRegisterChanged(registrationInfoZK, true);
    }

    @Override
    protected void doUnregister(URL url) {
        RegistrationInfo registrationInfoZK = this.builder.buildzk(url);
        this.registryCenter.doRemoveRegister(registrationInfoZK);
        this.registryCenter.doNotifyConsumerRegisterChanged(registrationInfoZK, false);
    }

    @Override
    protected void doSubscribe(final URL url, final NotifyListener listener) {
        RegistrationInfo registrationInfoZK = this.builder.buildzk(url);
        ConcurrentMap listeners = this.callBackListeners.computeIfAbsent(url, k -> new ConcurrentHashMap());
        CallNotify callNotifyListener = listeners.computeIfAbsent(listener, k -> new CallNotify(){

            public void notifyChange(String parentPath, List<String> currentChilds) {
                if (currentChilds == null || currentChilds.isEmpty()) {
                    KCommonRegistry.this._notify(url, listener, KCommonRegistry.this.lookup(url));
                } else {
                    KCommonRegistry.this._notify(url, listener, KCommonRegistry.this.toUrlsWithEmpty(url, parentPath, currentChilds));
                }
            }
        });
        this.registryCenter.doAddSubscribeListener(registrationInfoZK, callNotifyListener);
    }

    private void _notify(URL url, NotifyListener listener, List<URL> currentChildrenUrls) {
        this.notify(url, listener, currentChildrenUrls);
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        CallNotify notify;
        RegistrationInfo registrationInfoZK = this.builder.buildzk(url);
        ConcurrentMap listeners = (ConcurrentMap)this.callBackListeners.get(url);
        if (listeners != null && (notify = (CallNotify)listeners.get(listener)) != null) {
            this.registryCenter.doRemoveSubscribeListener(registrationInfoZK, notify);
        }
    }

    public List<URL> lookup(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("lookup url == null");
        }
        RegistrationInfo registrationInfoZK = this.builder.buildzk(url);
        try {
            ArrayList<String> providers = new ArrayList<String>();
            for (String path : registrationInfoZK.categoriesPath) {
                List children = this.registryCenter.getProviderList(registrationInfoZK, path);
                if (children == null || children.size() <= 0) continue;
                providers.addAll(children);
            }
            return this.toUrlsWithoutEmpty(url, providers);
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to lookup " + url + " from zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    public boolean isAvailable() {
        return false;
    }

    private List<URL> toUrlsWithEmpty(URL consumer, String path, List<String> providers) {
        List<URL> urls = this.toUrlsWithoutEmpty(consumer, providers);
        if (urls.isEmpty()) {
            int i = path.lastIndexOf(47);
            String category = i < 0 ? path : path.substring(i + 1);
            URL empty = consumer.setProtocol("empty").addParameter("category", category);
            urls.add(empty);
        }
        return urls;
    }

    private List<URL> toUrlsWithoutEmpty(URL consumer, List<String> providers) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (providers != null && providers.size() > 0) {
            for (String provider : providers) {
                URL url;
                if (!(provider = URL.decode(provider)).contains("://") || !UrlUtils.isMatch(consumer, url = URL.valueOf(provider))) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    @Override
    protected void checkProviderNodeExists() {
        HashSet recoverRegistered = new HashSet(this.getRegistered());
        if (Instance.isPausedServiceByMonitor()) {
            recoverRegistered.forEach(url -> this.doUnregister((URL)url));
            this.hasPaused = true;
        } else if (this.index.incrementAndGet() % (long)this.div == 0L) {
            recoverRegistered.forEach(url -> {
                if (this.hasPaused) {
                    this.doRegister((URL)url);
                } else if (this.registryCenter.isRegistryEphemeral() && (RequestStatus.isAppRequestFrequency(url.getParameter("group")) || this.random.nextInt(100) % 10 == 0)) {
                    this.doRegister((URL)url);
                    LockSupport.parkNanos(10000000L);
                }
            });
            this.hasPaused = false;
        }
    }
}

