/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.nacos;

import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class RegistryNotifier {
    private static final Log logger = LogFactory.getLog(RegistryNotifier.class);
    private volatile long lastEventTime;
    private Object rawAddresses;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("nacos-notify-subscribe-task", true));

    public synchronized void notify(Object rawAddresses) {
        long notifyTime;
        this.rawAddresses = rawAddresses;
        this.lastEventTime = notifyTime = System.currentTimeMillis();
        scheduler.schedule(new NotificationTask(this, notifyTime), TimeUnit.SECONDS.toMillis(10L), TimeUnit.MILLISECONDS);
    }

    protected abstract void doNotify(Object var1);

    public static class NotificationTask
    implements Runnable {
        private final RegistryNotifier listener;
        private final long time;

        public NotificationTask(RegistryNotifier listener, long time) {
            this.listener = listener;
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (this.time != this.listener.lastEventTime) break block6;
                    this.listener.doNotify(this.listener.rawAddresses);
                    RegistryNotifier registryNotifier = this.listener;
                    synchronized (registryNotifier) {
                        if (this.time == this.listener.lastEventTime) {
                            this.listener.rawAddresses = null;
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error("Error occurred when notify directory. ", t);
                }
            }
        }
    }
}

