/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.zookeeper;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.alibaba.dubbo.common.utils.UrlUtils;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.support.FailbackRegistry;
import com.alibaba.dubbo.remoting.zookeeper.ChildListener;
import com.alibaba.dubbo.remoting.zookeeper.StateListener;
import com.alibaba.dubbo.remoting.zookeeper.ZookeeperClient;
import com.alibaba.dubbo.remoting.zookeeper.ZookeeperTransporter;
import com.alibaba.dubbo.remoting.zookeeper.curator.CuratorZookeeperClient;
import com.alibaba.dubbo.rpc.RpcException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import kd.bos.instance.Instance;
import kd.bos.mservice.rpc.dubbo.DubboHealthManager;
import kd.bos.mservice.rpc.dubbo.rpc.RequestStatus;
import kd.bos.zk.ZKFactory;

public class ZookeeperRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperRegistry.class);
    private static final int DEFAULT_ZOOKEEPER_PORT = 2181;
    private static final String DEFAULT_ROOT = "dubbo";
    private final String root;
    private final SecureRandom random = new SecureRandom();
    private final Set<String> anyServices = new ConcurrentHashSet();
    private final ConcurrentMap<URL, ConcurrentMap<NotifyListener, ChildListener>> zkListeners = new ConcurrentHashMap<URL, ConcurrentMap<NotifyListener, ChildListener>>();
    private final ZookeeperClient zkClient;
    private final List<ZookeeperClient> friendsZkClients = new ArrayList<ZookeeperClient>(2);
    private final List<String> friendsZkRootPath = new ArrayList<String>(2);
    private static final String[] anyCategroies = new String[]{"providers", "consumers", "routers", "configurators"};
    private AtomicLong index = new AtomicLong(this.random.nextInt(1000));
    private final int div = Integer.getInteger("dubbo.failregister.interval", 60) / 5;
    private static final boolean isAddGroupInCategoryPath = Boolean.parseBoolean(System.getProperty("dubbo.registry.category.withgourp", "true"));
    private static final Map<String, AtomicBoolean> initedMap = new ConcurrentHashMap<String, AtomicBoolean>(2);

    public ZookeeperRegistry(final URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String rootPath = url.getParameter("root");
        if (rootPath != null) {
            this.root = rootPath;
        } else {
            String group = url.getParameter("group", DEFAULT_ROOT);
            if (!group.startsWith("/")) {
                group = "/" + group;
            }
            this.root = group;
        }
        this.zkClient = zookeeperTransporter.connect(url);
        this.zkClient.addStateListener(new StateListener(){

            public void stateChanged(int state) {
                if (state == 2) {
                    try {
                        logger.warn("reconnected zookeeper :" + url);
                        ZookeeperRegistry.this.recover();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        this.addFriendsZkClient();
        DubboHealthManager.registRootPath(this.root);
        DubboHealthManager.setZkClient(this.zkClient);
    }

    private void addFriendsZkClient() {
        String friendstr = System.getProperty("mservice.friends.registry");
        if (friendstr != null) {
            String[] frineds;
            for (String friend : frineds = friendstr.split("@;@")) {
                this.friendsZkClients.add((ZookeeperClient)new CuratorZookeeperClient(ZKFactory.getZKClient((String)friend)));
                String dubboRPath = ZKFactory.getZkRootPath((String)friend);
                String split = System.getProperty("dubbo.registry.clusterSplit");
                if ((split == null || "true".equals(split)) && Instance.getClusterName() != null) {
                    this.friendsZkRootPath.add(dubboRPath + "kdubbo/" + Instance.getClusterName());
                    continue;
                }
                this.friendsZkRootPath.add(dubboRPath + DEFAULT_ROOT);
            }
        }
    }

    public boolean isAvailable() {
        return this.zkClient.isConnected();
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.zkClient.close();
            this.friendsZkClients.forEach(ck -> ck.close());
        }
        catch (Exception e) {
            logger.warn("Failed to close zookeeper client " + this.getUrl() + ", cause:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void doRegister(URL url) {
        try {
            this.preParse(url);
            this.zkClient.create(this.toUrlPath(url), url.getParameter("dynamic", true));
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to register " + url + " to zookeeper: " + this.getUrl() + ",cause: " + e.getMessage(), e);
        }
    }

    private void preParse(URL url) {
        String categoryPath = this.toCategoryPath(url);
        AtomicBoolean inited = initedMap.computeIfAbsent(categoryPath, v -> new AtomicBoolean(false));
        if ("true".equals(System.getProperty("dubbo.provider.checkwhenstart", "true")) && inited.compareAndSet(false, true)) {
            String address = url.getAddress();
            List children = this.zkClient.getChildren(categoryPath);
            if (children == null || address == null || address.indexOf(58) < 0) {
                return;
            }
            children.forEach(child -> {
                try {
                    URL childUrl;
                    String c = URL.decode(child);
                    if (c.contains("://") && address.equals((childUrl = URL.valueOf(c)).getAddress())) {
                        this.zkClient.delete(this.toUrlPath(childUrl));
                        logger.warn("remove sameaddress url in zk: " + childUrl);
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            });
        }
    }

    @Override
    protected void doUnregister(URL url) {
        try {
            this.zkClient.delete(this.toUrlPath(url));
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to unregister " + url + " to zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    protected void doSubscribe(final URL url, final NotifyListener listener) {
        try {
            if ("*".equals(url.getServiceInterface())) {
                ChildListener zkListener;
                String root = this.toRootPath();
                ConcurrentMap listeners = (ConcurrentMap)this.zkListeners.get(url);
                if (listeners == null) {
                    this.zkListeners.putIfAbsent(url, new ConcurrentHashMap());
                    listeners = (ConcurrentMap)this.zkListeners.get(url);
                }
                if ((zkListener = (ChildListener)listeners.get(listener)) == null) {
                    listeners.putIfAbsent(listener, new ChildListener(){

                        public void childChanged(String parentPath, List<String> currentChilds) {
                            for (String child : currentChilds) {
                                child = URL.decode(child);
                                if (!ZookeeperRegistry.this.anyServices.add(child)) continue;
                                ZookeeperRegistry.this.subscribe(url.setPath(child).addParameters("interface", child, "check", String.valueOf(false)), listener);
                            }
                        }
                    });
                    zkListener = (ChildListener)listeners.get(listener);
                }
                this.zkClient.create(root, false);
                List services = this.zkClient.addChildListener(root, zkListener);
                if (services != null && services.size() > 0) {
                    for (String service : services) {
                        service = URL.decode(service);
                        this.anyServices.add(service);
                        this.subscribe(url.setPath(service).addParameters("interface", service, "check", String.valueOf(false)), listener);
                    }
                }
            } else {
                ArrayList<URL> urls = new ArrayList<URL>();
                block3: for (String path : this.toCategoriesPath(url)) {
                    ConcurrentMap listeners = this.zkListeners.computeIfAbsent(url, k -> new ConcurrentHashMap());
                    ChildListener zkListener = listeners.computeIfAbsent(listener, k -> new ChildListener(){

                        public void childChanged(String parentPath, List<String> currentChilds) {
                            if ((currentChilds == null || currentChilds.isEmpty()) && ZookeeperRegistry.this.friendsZkClients.size() > 0) {
                                ZookeeperRegistry.this.notify(url, listener, ZookeeperRegistry.this.lookup(url));
                            } else {
                                ZookeeperRegistry.this.notify(url, listener, ZookeeperRegistry.this.toUrlsWithEmpty(url, parentPath, currentChilds));
                            }
                        }
                    });
                    this.zkClient.create(path, false);
                    List children = this.zkClient.addChildListener(path, zkListener);
                    if (children != null && children.size() > 0) {
                        urls.addAll(this.toUrlsWithEmpty(url, path, children));
                        continue;
                    }
                    String fpath = path.substring(this.root.length());
                    for (int i = 0; i < this.friendsZkClients.size(); ++i) {
                        ZookeeperClient zclient = this.friendsZkClients.get(i);
                        String _path = this.friendsZkRootPath.get(i) + fpath;
                        zclient.create(_path, false);
                        children = zclient.addChildListener(_path, zkListener);
                        if (children == null || children.size() <= 0) continue;
                        urls.addAll(this.toUrlsWithEmpty(url, _path, children));
                        continue block3;
                    }
                }
                this.notify(url, listener, urls);
            }
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to subscribe " + url + " to zookeeper:" + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        ChildListener zkListener;
        ConcurrentMap listeners = (ConcurrentMap)this.zkListeners.get(url);
        if (listeners != null && (zkListener = (ChildListener)listeners.get(listener)) != null) {
            this.zkClient.removeChildListener(this.toUrlPath(url), zkListener);
        }
    }

    public List<URL> lookup(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("lookup url == null");
        }
        try {
            ArrayList<String> providers = new ArrayList<String>();
            block2: for (String path : this.toCategoriesPath(url)) {
                List children = this.zkClient.getChildren(path);
                if (children != null && children.size() > 0) {
                    providers.addAll(children);
                    continue;
                }
                String fpath = path.substring(this.root.length());
                for (int i = 0; i < this.friendsZkClients.size(); ++i) {
                    String _path;
                    ZookeeperClient zclient = this.friendsZkClients.get(i);
                    children = zclient.getChildren(_path = this.friendsZkRootPath.get(i) + fpath);
                    if (children == null || children.size() <= 0) continue;
                    providers.addAll(children);
                    continue block2;
                }
            }
            return this.toUrlsWithoutEmpty(url, providers);
        }
        catch (Error | Exception e) {
            throw new RpcException("Failed to lookup " + url + " from zookeeper " + this.getUrl() + ", cause: " + e.getMessage(), e);
        }
    }

    private String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    private String toRootPath() {
        return this.root;
    }

    private String toServicePath(URL url) {
        String name = url.getServiceInterface();
        if ("*".equals(name)) {
            return this.toRootPath();
        }
        String group = url.getParameter("group");
        if (isAddGroupInCategoryPath && group != null && group.length() > 0) {
            return this.toRootDir() + URL.encode(name) + "/" + group;
        }
        return this.toRootDir() + URL.encode(name);
    }

    private String[] toCategoriesPath(URL url) {
        String[] categroies = "*".equals(url.getParameter("category")) ? anyCategroies : url.getParameter("category", new String[]{"providers"});
        String[] paths = new String[categroies.length];
        for (int i = 0; i < categroies.length; ++i) {
            paths[i] = this.toServicePath(url) + "/" + categroies[i];
        }
        return paths;
    }

    private String toCategoryPath(URL url) {
        return this.toServicePath(url) + "/" + url.getParameter("category", "providers");
    }

    public String toUrlPath(URL url) {
        String urlPath = this.toCategoryPath(url) + "/" + URL.encode(url.toFullString());
        return urlPath;
    }

    private List<URL> toUrlsWithoutEmpty(URL consumer, List<String> providers) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (providers != null && providers.size() > 0) {
            for (String provider : providers) {
                URL url;
                if (!(provider = URL.decode(provider)).contains("://") || !UrlUtils.isMatch(consumer, url = URL.valueOf(provider))) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private List<URL> toUrlsWithEmpty(URL consumer, String path, List<String> providers) {
        List<URL> urls = this.toUrlsWithoutEmpty(consumer, providers);
        if (urls.isEmpty()) {
            int i = path.lastIndexOf(47);
            String category = i < 0 ? path : path.substring(i + 1);
            URL empty = consumer.setProtocol("empty").addParameter("category", category);
            urls.add(empty);
        }
        return urls;
    }

    static String appendDefaultPort(String address) {
        if (address != null && address.length() > 0) {
            int i = address.indexOf(58);
            if (i < 0) {
                return address + ":" + 2181;
            }
            if (Integer.parseInt(address.substring(i + 1)) == 0) {
                return address.substring(0, i + 1) + 2181;
            }
        }
        return address;
    }

    @Override
    protected void checkProviderNodeExists() {
        HashSet recoverRegistered = new HashSet(this.getRegistered());
        if (Instance.isPausedServiceByMonitor()) {
            recoverRegistered.forEach(url -> this.doUnregister((URL)url));
        } else if (this.index.incrementAndGet() % (long)this.div == 0L) {
            recoverRegistered.forEach(url -> {
                if (RequestStatus.isAppRequestFrequency(url.getParameter("group")) || this.random.nextInt(100) % 10 == 0) {
                    this.doRegister((URL)url);
                    LockSupport.parkNanos(10000000L);
                }
            });
        }
    }
}

