/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.exchange.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentTable<R, C, V> {
    private static Map<Object, Map<Object, Object>> processingRequest = new ConcurrentHashMap<Object, Map<Object, Object>>();

    public void put(R rowKey, C columnKey, V value) {
        this.getOrCreate(rowKey).put(columnKey, value);
    }

    public void remove(R rowKey, C columnKey) {
        this.getOrCreate(rowKey).remove(columnKey);
    }

    public Map<C, V> row(R rowKey) {
        return this.getOrCreate(rowKey);
    }

    public int size() {
        AtomicInteger size = new AtomicInteger(0);
        processingRequest.forEach((k, v) -> {
            if (v != null) {
                size.addAndGet(v.size());
            }
        });
        return size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<C, V> getOrCreate(R rowKey) {
        Map<Object, Object> m = processingRequest.get(rowKey);
        if (m == null) {
            Map<Object, Map<Object, Object>> map = processingRequest;
            synchronized (map) {
                m = processingRequest.get(rowKey);
                if (m == null) {
                    m = new ConcurrentHashMap<Object, Object>();
                    processingRequest.put(rowKey, m);
                }
            }
        }
        return m;
    }
}

