/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.exchange.support;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.Ping;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.TimeoutException;
import com.alibaba.dubbo.remoting.exchange.Request;
import com.alibaba.dubbo.remoting.exchange.Response;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.exception.DubboErrorCode;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.trace.util.TraceIdUtil;

public class DefaultFuture
implements ResponseFuture {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFuture.class);
    private static final Map<Long, Channel> CHANNELS = new ConcurrentHashMap<Long, Channel>();
    private static final Map<Long, DefaultFuture> FUTURES = new ConcurrentHashMap<Long, DefaultFuture>();
    private static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    private final long id;
    private final Channel channel;
    private final Request request;
    private int timeout;
    private boolean requestOrResponselost = false;
    private final Lock lock = new ReentrantLock();
    private final Condition done = this.lock.newCondition();
    private final long start = System.currentTimeMillis();
    private long touchTimeByPong = System.currentTimeMillis();
    private volatile long sent;
    private volatile Response response;
    private volatile ResponseCallback callback;
    private String providerInstanceId;

    public DefaultFuture(Channel channel, Request request, int timeout) {
        this.channel = channel;
        this.request = request;
        this.id = request.getId();
        this.timeout = timeout > 0 ? timeout : channel.getUrl().getPositiveParameter("timeout", 1000);
        FUTURES.put(this.id, this);
        CHANNELS.put(this.id, channel);
    }

    public Object get() throws RemotingException {
        try (MemSpanTrace span = MemSpanTrace.create((String)"DefaultFuture", (String)("get[" + this.channel.getLocalAddress() + " -> " + this.channel.getRemoteAddress() + "]"));){
            span.addTag("requestId", Ping.instance.getClientInstanceId() + "," + this.request.getId());
            span.addTag("remoteUrl", this.channel.getRemoteAddress() + "");
            Object object = this.get(this.timeout);
            return object;
        }
    }

    public Object get(int timeout) throws RemotingException {
        if (timeout <= 0) {
            timeout = 1000;
        }
        if (!this.isDone()) {
            long start = System.currentTimeMillis();
            this.lock.lock();
            try {
                while (!this.isDone()) {
                    this.done.await(timeout, TimeUnit.MILLISECONDS);
                    if (!this.isDone() && System.currentTimeMillis() - start <= (long)timeout) continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.unlock();
            }
            if (!this.isDone()) {
                throw new TimeoutException(this.sent > 0L ? DubboErrorCode.providerTimeOut.getCode() : DubboErrorCode.consumerTimeOut.getCode(), this.sent > 0L, this.channel, this.getTimeoutMessage(false));
            }
        }
        return this.returnFromResponse();
    }

    public void cancel() {
        Response errorResult = new Response(this.id);
        errorResult.setErrorMessage("request future has been canceled.");
        this.response = errorResult;
        FUTURES.remove(this.id);
        CHANNELS.remove(this.id);
    }

    public boolean isDone() {
        return this.response != null;
    }

    public void setCallback(ResponseCallback callback) {
        if (this.isDone()) {
            this.invokeCallback(callback);
        } else {
            boolean isdone = false;
            this.lock.lock();
            try {
                if (!this.isDone()) {
                    this.callback = callback;
                } else {
                    isdone = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (isdone) {
                this.invokeCallback(callback);
            }
        }
    }

    private void invokeCallback(ResponseCallback c) {
        ResponseCallback callbackCopy = c;
        if (callbackCopy == null) {
            throw new NullPointerException("callback cannot be null.");
        }
        c = null;
        Response res = this.response;
        if (res == null) {
            throw new IllegalStateException("response cannot be null. url:" + this.channel.getUrl());
        }
        if (res.getStatus() == 20) {
            try {
                callbackCopy.done(res.getResult());
            }
            catch (Exception e) {
                logger.error("callback invoke error .reasult:" + res.getResult() + ",url:" + this.channel.getUrl(), (Throwable)e);
            }
        } else if (res.getStatus() == 30 || res.getStatus() == 31) {
            try {
                TimeoutException te = new TimeoutException(res.getStatus() == 31, this.channel, res.getErrorMessage());
                callbackCopy.caught((Throwable)te);
            }
            catch (Exception e) {
                logger.error("callback invoke error ,url:" + this.channel.getUrl(), (Throwable)e);
            }
        } else {
            try {
                RuntimeException re = new RuntimeException(res.getErrorMessage());
                callbackCopy.caught((Throwable)re);
            }
            catch (Exception e) {
                logger.error("callback invoke error ,url:" + this.channel.getUrl(), (Throwable)e);
            }
        }
    }

    private Object returnFromResponse() throws RemotingException {
        Response res = this.response;
        if (res == null) {
            throw new IllegalStateException("response cannot be null");
        }
        if (res.getStatus() == 20) {
            return res.getResult();
        }
        if (res.getStatus() == 30 || res.getStatus() == 31 || res.getStatus() == 81) {
            throw new TimeoutException(this.getErrorCode(res.getStatus()), res.getStatus() == 31, this.channel, res.getErrorMessage());
        }
        throw new RemotingException(this.getErrorCode(res.getStatus()), this.channel, res.getErrorMessage());
    }

    private long getId() {
        return this.id;
    }

    private Channel getChannel() {
        return this.channel;
    }

    private boolean isSent() {
        return this.sent > 0L;
    }

    public Request getRequest() {
        return this.request;
    }

    private int getTimeout() {
        return this.timeout;
    }

    private long getStartTimestamp() {
        return this.start;
    }

    public static DefaultFuture getFuture(long id) {
        return FUTURES.get(id);
    }

    public static boolean hasFuture(Channel channel) {
        return CHANNELS.containsValue(channel);
    }

    public static void sent(Channel channel, Request request) {
        DefaultFuture future = FUTURES.get(request.getId());
        if (future != null) {
            future.doSent();
        }
    }

    private void doSent() {
        this.sent = System.currentTimeMillis();
    }

    public static void received(Channel channel, Response response) {
        try {
            DefaultFuture future = FUTURES.remove(response.getId());
            if (future != null) {
                future.doReceived(response);
            } else {
                logger.warn("The timeout response finally returned at " + new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_SSS).format(new Date()) + ", response " + response + (channel == null ? "" : ", channel: " + channel.getLocalAddress() + " -> " + channel.getRemoteAddress()));
            }
        }
        finally {
            CHANNELS.remove(response.getId());
        }
    }

    private void doReceived(Response res) {
        this.lock.lock();
        try {
            this.response = res;
            if (this.done != null) {
                this.done.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.callback != null) {
            this.invokeCallback(this.callback);
        }
    }

    private String getTimeoutMessage(boolean scan) {
        long nowTimestamp = System.currentTimeMillis();
        return (this.requestOrResponselost ? Thread.currentThread().getName() + ",requestid:" + this.request.getId() + ",Request id is not in the processing id list of provider." : (this.sent > 0L ? "Waiting server-side response timeout" : "Sending request timeout in client-side")) + (scan ? " by scan timer" : "") + ". start time: " + new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_SSS).format(new Date(this.start)) + ", end time: " + new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_SSS).format(new Date()) + "," + (this.sent > 0L ? " client elapsed: " + (this.sent - this.start) + " ms, server elapsed: " + (nowTimestamp - this.sent) : " elapsed: " + (nowTimestamp - this.start)) + " ms, timeout: " + this.timeout + " ms, request: " + this.request + ", channel: " + this.channel.getLocalAddress() + " -> " + this.channel.getRemoteAddress() + " ,traceid:" + TraceIdUtil.getCurrentTraceIdString() + " instanceId=" + (this.providerInstanceId != null ? this.providerInstanceId : this.channel.getRemoteAddress().getAddress().getHostAddress()) + " @end timeout=" + (nowTimestamp - this.start) / 1000L + " #end";
    }

    public static void clearFutureWhenChannelClosed(IOException e, Channel channelThrow) {
        for (DefaultFuture future : FUTURES.values()) {
            if (future == null || future.isDone()) continue;
            Channel thischannel = future.getChannel();
            if (channelThrow == null || thischannel == null || !channelThrow.getRemoteAddress().equals(thischannel.getRemoteAddress())) continue;
            Response response = new Response(future.getId());
            response.setStatus((byte)50);
            response.setErrorMessage("Socket Closed:" + thischannel + "," + e.getMessage());
            DefaultFuture.received(future.getChannel(), response);
        }
    }

    public static void delayFuture(Channel channel, Long[] processings, String providerInstanceId) {
        Long[] requestids;
        if (processings == null) {
            return;
        }
        HashSet processingSet = new HashSet();
        Collections.addAll(processingSet, processings);
        for (Long requestid : requestids = DefaultFuture.getRequestids(channel)) {
            long newtimeout;
            DefaultFuture _future;
            if (processingSet.contains(requestid)) {
                _future = FUTURES.get(requestid);
                if (_future == null) continue;
                _future.providerInstanceId = providerInstanceId;
                _future.touchTimeByPong = System.currentTimeMillis();
                continue;
            }
            logger.warn("removeUnhealthFuture:channel [" + channel.getLocalAddress() + " -> " + channel.getRemoteAddress() + "]," + requestid);
            _future = FUTURES.get(requestid);
            if (_future == null || System.currentTimeMillis() - _future.getStartTimestamp() <= 60000L || (newtimeout = System.currentTimeMillis() - _future.getStartTimestamp() + 30000L) >= (long)_future.timeout) continue;
            _future.timeout = (int)newtimeout;
            _future.requestOrResponselost = true;
        }
    }

    private static Long[] getRequestids(Channel channel) {
        Long[] requestids = CHANNELS.keySet().toArray(new Long[0]);
        HashSet<Long> l = new HashSet<Long>();
        for (Long requestid : requestids) {
            if (CHANNELS.get(requestid) != channel) continue;
            l.add(requestid);
        }
        return l.toArray(new Long[0]);
    }

    public static void delayFuture(Channel channel) {
        Long[] requestids = DefaultFuture.getRequestids(channel);
        logger.warn("removeUnhealthFuture of channel: channel[" + channel.getLocalAddress() + " -> " + channel.getRemoteAddress() + "]," + requestids);
        for (Long requestid : requestids) {
            long newtimeout;
            DefaultFuture _future = FUTURES.get(requestid);
            if (_future == null || System.currentTimeMillis() - _future.getStartTimestamp() <= 60000L || (newtimeout = System.currentTimeMillis() - _future.getStartTimestamp() + 30000L) >= (long)_future.timeout) continue;
            _future.timeout = (int)newtimeout;
            _future.requestOrResponselost = true;
        }
    }

    public int getErrorCode(byte status) {
        switch (status) {
            case 80: {
                return DubboErrorCode.providerExecute.getCode();
            }
            case 31: {
                return DubboErrorCode.providerTimeOut.getCode();
            }
            case 81: {
                return DubboErrorCode.providerNotResponse.getCode();
            }
            case 30: {
                return DubboErrorCode.consumerTimeOut.getCode();
            }
        }
        return status;
    }

    static {
        Thread th = new Thread((Runnable)new RemotingInvocationTimeoutScan(), "DubboResponseTimeoutScanTimer");
        th.setDaemon(true);
        th.start();
    }

    private static class RemotingInvocationTimeoutScan
    implements Runnable {
        private RemotingInvocationTimeoutScan() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        for (DefaultFuture future : FUTURES.values()) {
                            Response timeoutResponse;
                            if (future == null || future.isDone()) continue;
                            if (System.currentTimeMillis() - future.getStartTimestamp() > (long)future.getTimeout()) {
                                timeoutResponse = new Response(future.getId());
                                timeoutResponse.setStatus(future.isSent() ? (byte)31 : 30);
                                timeoutResponse.setErrorMessage(future.getTimeoutMessage(true));
                                DefaultFuture.received(future.getChannel(), timeoutResponse);
                                continue;
                            }
                            if (System.currentTimeMillis() - future.touchTimeByPong <= (long)(Integer.getInteger("dubbo.pong.timeout.seconds", 180) * 1000) || Boolean.getBoolean("dubbo.keepfuturebypong.disable")) continue;
                            future.requestOrResponselost = true;
                            timeoutResponse = new Response(future.getId());
                            timeoutResponse.setStatus(future.isSent() ? (byte)81 : 30);
                            timeoutResponse.setErrorMessage("future touchTime By Pong time out," + future.getTimeoutMessage(true));
                            DefaultFuture.received(future.getChannel(), timeoutResponse);
                            logger.warn("removeUnhealthFuture which future touchTime By Pong time out:channel[" + future.getChannel() + " -> " + future.getChannel() + "]," + future.getId());
                        }
                        Thread.sleep(30L);
                    }
                }
                catch (Error | Exception e) {
                    logger.error("Exception when scan the timeout invocation of remoting.", e);
                    continue;
                }
                break;
            }
        }
    }
}

