/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.exchange.support;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.remoting.exchange.Response;
import com.alibaba.dubbo.remoting.exchange.support.ConcurrentTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class HandlingStatus {
    private static ConcurrentTable<String, Long, Long> processingRequest = new ConcurrentTable();
    protected static final Logger logger = LoggerFactory.getLogger(HandlingStatus.class);
    public static final String DUBBOREQUESTIDKEY = "RPC.RequestId";
    private static Map<String, List<Response>> responses;
    private static Map<String, Long> touchTime;

    public static void receiveHandleRequest(String clientInstanceId, long rid) {
        logger.debug("receiveHandleRequest requestId:" + clientInstanceId + "," + rid);
    }

    public static void beginHandleRequest(String clientInstanceId, long rid) {
        logger.debug("beginHandleRequest requestId:" + clientInstanceId + "," + rid);
        processingRequest.put(clientInstanceId, rid, System.currentTimeMillis());
    }

    public static void endHandleRequest(String clientInstanceId, long rid) {
        logger.debug("endHandleRequest requestId:" + clientInstanceId + "," + rid);
        processingRequest.remove(clientInstanceId, rid);
    }

    public static void beginSyncResponse(String clientInstanceId, long rid) {
        logger.debug("beginSyncResponse requestId:" + clientInstanceId + "," + rid);
    }

    public static Long[] getProcessingList(String clientInstanceId) {
        Map<Long, Long> m = processingRequest.row(clientInstanceId);
        return m.keySet().toArray(new Long[0]);
    }

    public static int getHandlingCount() {
        return processingRequest.size();
    }

    public static void handleResponse(String clientInstanceId, Response response) {
        List<Response> responsels = HandlingStatus.getOrReplaceClientResponses(clientInstanceId);
        responsels.add(response);
    }

    public static List<Response> getResponseList(String clientInstanceId) {
        touchTime.put(clientInstanceId, System.currentTimeMillis());
        List<Response> responseLs = responses.get(clientInstanceId);
        if (responseLs == null || responseLs.size() == 0) {
            return Collections.emptyList();
        }
        return new ArrayList<Response>(responseLs);
    }

    public static void remove(String clientInstanceId, Response r) {
        List<Response> responsels = HandlingStatus.getOrReplaceClientResponses(clientInstanceId);
        responsels.remove(r);
    }

    private static List<Response> getOrReplaceClientResponses(String clientInstanceId) {
        return responses.computeIfAbsent(clientInstanceId, k -> new ArrayList());
    }

    private static void removeExpiredClientResponse() {
        long timeout = Integer.getInteger("dubbo.client.resend.timeout", 1800000).intValue();
        touchTime.forEach((k, v) -> {
            if (System.currentTimeMillis() - v > timeout) {
                responses.remove(k);
            }
        });
    }

    static {
        ScheduledExecutorService es = Executors.newScheduledThreadPool(1);
        es.scheduleAtFixedRate(() -> HandlingStatus.removeExpiredClientResponse(), 300L, 60L, TimeUnit.SECONDS);
        responses = new ConcurrentHashMap<String, List<Response>>();
        touchTime = new ConcurrentHashMap<String, Long>();
    }
}

