/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.exchange.support.header;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.ExecutionException;
import com.alibaba.dubbo.remoting.Ping;
import com.alibaba.dubbo.remoting.Pong;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.exchange.ExchangeChannel;
import com.alibaba.dubbo.remoting.exchange.ExchangeHandler;
import com.alibaba.dubbo.remoting.exchange.Request;
import com.alibaba.dubbo.remoting.exchange.Response;
import com.alibaba.dubbo.remoting.exchange.support.DefaultFuture;
import com.alibaba.dubbo.remoting.exchange.support.HandlingStatus;
import com.alibaba.dubbo.remoting.exchange.support.header.HeaderExchangeChannel;
import com.alibaba.dubbo.remoting.exchange.support.header.HeartbeatHandler;
import com.alibaba.dubbo.remoting.transport.ChannelHandlerDelegate;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.RpcInvocation;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.instance.Instance;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.MserviceStatus;
import kd.bos.mservice.monitor.MserviceStatusManger;
import kd.bos.mservice.rpc.dubbo.context.KDInvokeContext;
import kd.bos.mservice.rpc.handshake.entity.HandShakeRequest;
import kd.bos.mservice.rpc.handshake.entity.HandShakeResponse;
import kd.bos.mservice.rpc.handshake.entity.HandShakeStatus;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.KDThreadPoolFactory;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolEnum;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolExecutor;
import kd.bos.thread.ThreadTruck;

public class HeaderExchangeHandler
implements ChannelHandlerDelegate {
    protected static final Logger logger = LoggerFactory.getLogger(HeaderExchangeHandler.class);
    public static final String KEY_READ_TIMESTAMP = HeartbeatHandler.KEY_READ_TIMESTAMP;
    public static final String KEY_WRITE_TIMESTAMP = HeartbeatHandler.KEY_WRITE_TIMESTAMP;
    private final ExchangeHandler handler;
    private static KDThreadPoolExecutor executor = KDThreadPoolFactory.getOrCreate((String)KDThreadPoolEnum.RPC.getResourceName(), (int)10, (int)Integer.getInteger("dubbo.protocol.threads", 200));

    public HeaderExchangeHandler(ExchangeHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.handler = handler;
    }

    void handlerEvent(Channel channel, Request req) throws RemotingException {
        if (req.getData() != null && req.getData().equals("R")) {
            channel.setAttribute("channel.readonly", (Object)Boolean.TRUE);
        }
    }

    Response handleRequest(ExchangeChannel channel, Request req) throws RemotingException {
        Response res = new Response(req.getId(), req.getVersion());
        if (req.isBroken()) {
            Object data = req.getData();
            String msg = data == null ? null : (data instanceof Throwable ? StringUtils.toString((Throwable)((Throwable)data)) : data.toString());
            res.setErrorMessage("Fail to decode request due to: " + msg);
            res.setStatus((byte)40);
            return res;
        }
        Object msg = req.getData();
        try {
            Object result = this.handler.reply(channel, msg);
            res.setStatus((byte)20);
            res.setResult(result);
        }
        catch (Throwable e) {
            res.setStatus((byte)70);
            res.setErrorMessage(StringUtils.toString((Throwable)e));
        }
        return res;
    }

    static void handleResponse(Channel channel, Response response) throws RemotingException {
        if (response != null && !response.isHeartbeat()) {
            DefaultFuture.received(channel, response);
        }
    }

    public void connected(Channel channel) throws RemotingException {
        channel.setAttribute(KEY_READ_TIMESTAMP, (Object)System.currentTimeMillis());
        channel.setAttribute(KEY_WRITE_TIMESTAMP, (Object)System.currentTimeMillis());
        HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
        try {
            this.handler.connected((Channel)exchangeChannel);
        }
        finally {
            HeaderExchangeChannel.removeChannelIfDisconnected(channel);
        }
    }

    public void disconnected(Channel channel) throws RemotingException {
        channel.setAttribute(KEY_READ_TIMESTAMP, (Object)System.currentTimeMillis());
        channel.setAttribute(KEY_WRITE_TIMESTAMP, (Object)System.currentTimeMillis());
        HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
        try {
            this.handler.disconnected((Channel)exchangeChannel);
        }
        finally {
            HeaderExchangeChannel.removeChannelIfDisconnected(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sent(Channel channel, Object message) throws RemotingException {
        Throwable exception = null;
        try {
            channel.setAttribute(KEY_WRITE_TIMESTAMP, (Object)System.currentTimeMillis());
            HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
            try {
                this.handler.sent((Channel)exchangeChannel, message);
            }
            finally {
                HeaderExchangeChannel.removeChannelIfDisconnected(channel);
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        if (message instanceof Request) {
            Request request = (Request)message;
            DefaultFuture.sent(channel, request);
        } else if (message instanceof Response) {
            String transporter;
            Response response = (Response)message;
            String server = channel.getUrl().getParameter("server");
            String string = transporter = StringUtils.isEmpty((String)server) ? channel.getUrl().getParameter("transporter") : server;
            if ("netty4".equals(transporter) && response.getClientInstanceId() != null) {
                String clientInstanceId = response.getClientInstanceId();
                if (exception instanceof RemotingException) {
                    if (clientInstanceId != null) {
                        HandlingStatus.handleResponse(clientInstanceId, response);
                    }
                    logger.error("sendresponseansy error,will send by pong" + clientInstanceId + "," + response.getId(), exception);
                }
                HandlingStatus.endHandleRequest(response.getClientInstanceId(), response.getId());
            }
        }
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof RemotingException) {
                throw (RemotingException)exception;
            }
            throw new RemotingException(channel.getLocalAddress(), channel.getRemoteAddress(), exception.getMessage(), exception);
        }
    }

    private static boolean isClientSide(Channel channel) {
        InetSocketAddress address = channel.getRemoteAddress();
        URL url = channel.getUrl();
        return url.getPort() == address.getPort() && NetUtils.filterLocalHost((String)url.getIp()).equals(NetUtils.filterLocalHost((String)address.getAddress().getHostAddress()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void received(Channel channel, Object message) throws RemotingException {
        channel.setAttribute(KEY_READ_TIMESTAMP, (Object)System.currentTimeMillis());
        HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
        try {
            if (message instanceof Request) {
                Request request = (Request)message;
                if (request.isEvent()) {
                    Object data = request.getData();
                    if (data instanceof Ping) {
                        Response res = new Response(request.getId(), request.getVersion());
                        String clientInstanceId = ((Ping)data).getClientInstanceId();
                        res.setResult(Pong.create(clientInstanceId));
                        channel.send((Object)res);
                        List<Response> responses = HandlingStatus.getResponseList(clientInstanceId);
                        if (responses != null) {
                            responses.forEach(r -> {
                                try {
                                    channel.send(r);
                                    HandlingStatus.remove(clientInstanceId, r);
                                    logger.info(String.format("sendresponse response Pong:%s,%s", clientInstanceId, r));
                                }
                                catch (Exception e) {
                                    logger.error("sendresponse error by Pong", (Throwable)e);
                                }
                            });
                        }
                    } else if (data instanceof HandShakeRequest) {
                        long start = System.currentTimeMillis();
                        Response res = new Response(request.getId(), request.getVersion());
                        HandShakeRequest handRequest = (HandShakeRequest)data;
                        HandShakeResponse hsresponse = null;
                        if (Boolean.parseBoolean(System.getProperty("dubbo.handshake.refusewhenbusy", "true"))) {
                            MserviceStatus mst = MserviceStatusManger.getMserviceStatus();
                            int level = mst.getNodeHealthLevel().getLevel();
                            if (HealthLevel.OVERLOAD.getLevel() < level || Instance.isPausedServiceByMonitor()) {
                                hsresponse = new HandShakeResponse(HandShakeStatus.REFUSE, handRequest.getCheckCode());
                            } else if (HealthLevel.BUSY.getLevel() <= level) {
                                hsresponse = new HandShakeResponse(HandShakeStatus.BUSY, handRequest.getCheckCode());
                            }
                        }
                        if (hsresponse == null) {
                            hsresponse = new HandShakeResponse(HandShakeStatus.NORMAL, handRequest.getCheckCode());
                        }
                        hsresponse.setServerTime(System.currentTimeMillis() - start);
                        Object queueTime = ThreadTruck.get((Object)"rpcRequestQueueTime");
                        hsresponse.setServerQueueTime(queueTime == null ? -1L : (Long)queueTime);
                        res.setResult(hsresponse);
                        channel.send((Object)res);
                    } else {
                        this.handlerEvent(channel, request);
                    }
                } else if (request.isTwoWay()) {
                    KDInvokeContext kdInvokeContext;
                    long rid = request.getId();
                    Object mes = request.getData();
                    String _clientInstanceId = null;
                    if (mes instanceof Invocation) {
                        _clientInstanceId = ((Invocation)mes).getAttachment("clientInstanceId");
                        HandlingStatus.beginHandleRequest(_clientInstanceId, rid);
                        ((Invocation)mes).getAttachments().put("RPC.RequestId", _clientInstanceId + "," + rid);
                    }
                    if (mes instanceof RpcInvocation && (kdInvokeContext = ((RpcInvocation)mes).getInvokeContext()) != null && kdInvokeContext.getRequestContext() != null) {
                        RequestContext.set((RequestContext)kdInvokeContext.getRequestContext());
                    }
                    String clientInstanceId = _clientInstanceId;
                    Runnable runnable = () -> {
                        String transporter;
                        try {
                            Response response = null;
                            try {
                                response = this.handleRequest(exchangeChannel, request);
                            }
                            catch (Throwable e) {
                                logger.error("serverhandleRequest error", e);
                                response = new Response(request.getId(), request.getVersion());
                                response.setStatus((byte)70);
                                response.setErrorMessage(StringUtils.toString((Throwable)e));
                            }
                            try {
                                response.setClientInstanceId(clientInstanceId);
                                channel.send((Object)response);
                            }
                            catch (RemotingException e) {
                                if (clientInstanceId != null) {
                                    HandlingStatus.handleResponse(clientInstanceId, response);
                                }
                                logger.error("sendresponse error,will send by pong," + clientInstanceId + "," + rid, (Throwable)e);
                            }
                            if (clientInstanceId == null) return;
                        }
                        catch (Throwable throwable) {
                            String transporter2;
                            if (clientInstanceId == null) throw throwable;
                            String server = exchangeChannel.getUrl().getParameter("server");
                            String string = transporter2 = StringUtils.isEmpty((String)server) ? exchangeChannel.getUrl().getParameter("transporter") : server;
                            if (!"netty4".equals(transporter2)) {
                                HandlingStatus.endHandleRequest(clientInstanceId, rid);
                                throw throwable;
                            } else {
                                HandlingStatus.beginSyncResponse(clientInstanceId, rid);
                            }
                            throw throwable;
                        }
                        String server = exchangeChannel.getUrl().getParameter("server");
                        String string = transporter = StringUtils.isEmpty((String)server) ? exchangeChannel.getUrl().getParameter("transporter") : server;
                        if (!"netty4".equals(transporter)) {
                            HandlingStatus.endHandleRequest(clientInstanceId, rid);
                            return;
                        } else {
                            HandlingStatus.beginSyncResponse(clientInstanceId, rid);
                        }
                    };
                    if (Configs.isRpcResourceBalanceEnable()) {
                        try {
                            executor.execute(runnable);
                        }
                        catch (Throwable e) {
                            logger.error("serverhandleRequest error", e);
                            Response response = new Response(request.getId(), request.getVersion());
                            response.setStatus((byte)70);
                            response.setErrorMessage(StringUtils.toString((Throwable)e));
                            response.setClientInstanceId(clientInstanceId);
                            channel.send((Object)response);
                        }
                    } else {
                        runnable.run();
                    }
                } else {
                    this.handler.received((Channel)exchangeChannel, request.getData());
                }
            } else if (message instanceof Response) {
                HeaderExchangeHandler.handleResponse(channel, (Response)message);
            } else if (message instanceof String) {
                if (HeaderExchangeHandler.isClientSide(channel)) {
                    Exception e = new Exception("Dubbo client can not supported string message: " + message + " in channel: " + channel + ", url: " + channel.getUrl());
                    logger.error(e.getMessage(), (Throwable)e);
                } else {
                    String echo = this.handler.telnet(channel, (String)message);
                    if (echo != null && echo.length() > 0) {
                        channel.send((Object)echo);
                    }
                }
            } else {
                this.handler.received((Channel)exchangeChannel, message);
            }
        }
        finally {
            HeaderExchangeChannel.removeChannelIfDisconnected(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caught(Channel channel, Throwable exception) throws RemotingException {
        Request req;
        ExecutionException e;
        Object msg;
        if (exception instanceof ExecutionException && (msg = (e = (ExecutionException)exception).getRequest()) instanceof Request && (req = (Request)msg).isTwoWay() && !req.isHeartbeat()) {
            Response res = new Response(req.getId(), req.getVersion());
            res.setStatus((byte)80);
            res.setErrorMessage("instanceId=" + Instance.getClusterName().replace("_", "-") + "-" + Instance.getInstanceId() + " @end " + StringUtils.toString((Throwable)e));
            channel.send((Object)res);
            return;
        }
        HeaderExchangeChannel exchangeChannel = HeaderExchangeChannel.getOrAddChannel(channel);
        try {
            this.handler.caught((Channel)exchangeChannel, exception);
            if (Boolean.getBoolean("dubbo.log.remoteexception.enable")) {
                logger.error("remoteexception:", exception);
            }
            if (exception instanceof IOException && !Boolean.getBoolean("dubbo.remote.channel.close.wait") && exception.getStackTrace() != null && exception.getStackTrace()[0].isNativeMethod()) {
                DefaultFuture.clearFutureWhenChannelClosed((IOException)exception, channel);
            }
        }
        finally {
            HeaderExchangeChannel.removeChannelIfDisconnected(channel);
        }
    }

    public ChannelHandler getHandler() {
        if (this.handler instanceof ChannelHandlerDelegate) {
            return ((ChannelHandlerDelegate)this.handler).getHandler();
        }
        return this.handler;
    }
}

