/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.exchange.support.header;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.exchange.Request;
import com.alibaba.dubbo.remoting.exchange.Response;
import com.alibaba.dubbo.remoting.transport.AbstractChannelHandlerDelegate;

public class HeartbeatHandler
extends AbstractChannelHandlerDelegate {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatHandler.class);
    public static String KEY_READ_TIMESTAMP = "READ_TIMESTAMP";
    public static String KEY_WRITE_TIMESTAMP = "WRITE_TIMESTAMP";

    public HeartbeatHandler(ChannelHandler handler) {
        super(handler);
    }

    public void connected(Channel channel) throws RemotingException {
        this.setReadTimestamp(channel);
        this.setWriteTimestamp(channel);
        this.handler.connected(channel);
    }

    public void disconnected(Channel channel) throws RemotingException {
        this.clearReadTimestamp(channel);
        this.clearWriteTimestamp(channel);
        this.handler.disconnected(channel);
    }

    public void sent(Channel channel, Object message) throws RemotingException {
        this.setWriteTimestamp(channel);
        this.handler.sent(channel, message);
    }

    public void received(Channel channel, Object message) throws RemotingException {
        this.setReadTimestamp(channel);
        if (this.isHeartbeatRequest(message)) {
            Request req = (Request)message;
            if (req.isTwoWay()) {
                Response res = new Response(req.getId(), req.getVersion());
                res.setEvent(Response.HEARTBEAT_EVENT);
                channel.send((Object)res);
                if (logger.isInfoEnabled()) {
                    int heartbeat = channel.getUrl().getParameter("heartbeat", 0);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received heartbeat from remote channel " + channel.getRemoteAddress() + ", cause: The channel has no data-transmission exceeds a heartbeat period" + (heartbeat > 0 ? ": " + heartbeat + "ms" : ""));
                    }
                }
            }
            return;
        }
        if (this.isHeartbeatResponse(message)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Receive heartbeat response in thread " + Thread.currentThread().getName());
            }
            return;
        }
        try {
            this.handler.received(channel, message);
        }
        catch (RemotingException e) {
            if (Boolean.parseBoolean(System.getProperty("dubbo.provider.pool.reject.notify.enable", "true"))) {
                Request req = (Request)message;
                Response res = new Response(req.getId(), req.getVersion());
                res.setStatus((byte)40);
                res.setErrorMessage(e.getCause().toString());
                channel.send((Object)res);
            }
            throw e;
        }
    }

    private void setReadTimestamp(Channel channel) {
        channel.setAttribute(KEY_READ_TIMESTAMP, (Object)System.currentTimeMillis());
    }

    private void setWriteTimestamp(Channel channel) {
        channel.setAttribute(KEY_WRITE_TIMESTAMP, (Object)System.currentTimeMillis());
    }

    private void clearReadTimestamp(Channel channel) {
        channel.removeAttribute(KEY_READ_TIMESTAMP);
    }

    private void clearWriteTimestamp(Channel channel) {
        channel.removeAttribute(KEY_WRITE_TIMESTAMP);
    }

    private boolean isHeartbeatRequest(Object message) {
        return message instanceof Request && ((Request)message).isHeartbeat();
    }

    private boolean isHeartbeatResponse(Object message) {
        return message instanceof Response && ((Response)message).isHeartbeat();
    }
}

