/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.serialize.Serialization;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.Codec2;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.alibaba.dubbo.remoting.transport.ExceedPayloadLimitException;
import java.io.IOException;
import java.net.InetSocketAddress;
import kd.bos.mservice.common.limit.KServiceLimitUtil;

public abstract class AbstractCodec
implements Codec2 {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCodec.class);

    protected Serialization getSerialization(Channel channel) {
        return CodecSupport.getSerialization(channel.getUrl());
    }

    protected static void checkPayload(Channel channel, long size) throws IOException {
        if (KServiceLimitUtil.overLimit((long)size)) {
            ExceedPayloadLimitException e = new ExceedPayloadLimitException("Data length too large: " + size + ", max payload: " + KServiceLimitUtil.getLimitSize() + ", channel: " + channel);
            logger.error((Throwable)e);
            throw e;
        }
    }

    protected boolean isClientSide(Channel channel) {
        String side = (String)channel.getAttribute("side");
        if ("client".equals(side)) {
            return true;
        }
        if ("server".equals(side)) {
            return false;
        }
        InetSocketAddress address = channel.getRemoteAddress();
        URL url = channel.getUrl();
        boolean client = url.getPort() == address.getPort() && NetUtils.filterLocalHost((String)url.getIp()).equals(NetUtils.filterLocalHost((String)address.getAddress().getHostAddress()));
        channel.setAttribute("side", (Object)(client ? "client" : "server"));
        return client;
    }

    protected boolean isServerSide(Channel channel) {
        return !this.isClientSide(channel);
    }
}

