/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.zookeeper.curator;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.zookeeper.ChildListener;
import com.alibaba.dubbo.remoting.zookeeper.support.AbstractZookeeperClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.SystemProperties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryForever;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;

public class CuratorZookeeperClient
extends AbstractZookeeperClient<CuratorWatcher> {
    private static final Log log = LogFactory.getLog(CuratorZookeeperClient.class);
    private static final List<String> EMPTY_CHILDREN = Collections.unmodifiableList(Collections.EMPTY_LIST);
    private final URL url;
    private CuratorFramework client;

    public CuratorZookeeperClient(URL url) {
        super(url);
        this.url = url;
        this.startClient();
    }

    public CuratorZookeeperClient(CuratorFramework client) {
        super(null);
        this.url = null;
        this.client = client;
    }

    private void startClient() {
        Object retryPolicy = Boolean.getBoolean("ha.component.enable") && !kd.bos.util.StringUtils.isEmpty((String)SystemProperties.getWithEnv((String)"ha.zookeeper.backup")) ? new RetryNTimes(Integer.getInteger("zookeeper.client.retry.times", 3).intValue(), Integer.getInteger("zookeeper.client.retry.sleep.time", 1000).intValue()) : new RetryForever(Integer.getInteger("zookeeper.client.retry.intervalMs", 10000).intValue());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.url.getBackupAddress()).retryPolicy((RetryPolicy)retryPolicy).connectionTimeoutMs(this.url.getParameter("timeout", 5000)).sessionTimeoutMs(this.url.getParameter("session", Integer.getInteger("dubbo.zk.session", 60000)));
        final String authority = this.url.getAuthority();
        if (authority != null && authority.length() > 0) {
            builder = builder.authorization("digest", authority.getBytes());
            ACLProvider aclProvider = new ACLProvider(){
                private List<ACL> acl;

                public List<ACL> getDefaultAcl() {
                    if (this.acl == null) {
                        ArrayList acl = ZooDefs.Ids.CREATOR_ALL_ACL;
                        acl.clear();
                        acl.add(new ACL(31, new Id("auth", authority)));
                        this.acl = acl;
                    }
                    return this.acl;
                }

                public List<ACL> getAclForPath(String path) {
                    return this.acl;
                }
            };
            builder = builder.aclProvider(aclProvider);
        }
        this.client = builder.build();
        this.client.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState state) {
                if (state == ConnectionState.LOST) {
                    CuratorZookeeperClient.this.stateChanged(0);
                } else if (state == ConnectionState.CONNECTED) {
                    CuratorZookeeperClient.this.stateChanged(1);
                } else if (state == ConnectionState.RECONNECTED) {
                    CuratorZookeeperClient.this.stateChanged(2);
                }
            }
        });
        this.client.start();
    }

    public void createPersistent(String path) {
        try {
            Stat exists = (Stat)this.client.checkExists().forPath(path);
            if (exists == null) {
                this.client.create().forPath(path);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            log.warn((Throwable)e);
        }
        catch (Exception e) {
            this.praseException(e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void createEphemeral(String path) {
        try {
            Stat exists = (Stat)this.client.checkExists().forPath(path);
            if (exists == null) {
                ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(path);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            log.warn((Throwable)e);
        }
        catch (Exception e) {
            this.praseException(e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void delete(String path) {
        try {
            this.client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn((Throwable)e);
        }
        catch (Exception e) {
            this.praseException(e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public List<String> getChildren(String path) {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            this.praseException(e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public boolean isConnected() {
        return this.client.getZookeeperClient().isConnected();
    }

    public void doClose() {
        this.client.close();
    }

    public CuratorWatcher createTargetChildListener(String path, ChildListener listener) {
        return new CuratorWatcherImpl(listener);
    }

    public List<String> addTargetChildListener(String path, CuratorWatcher listener) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher(listener)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            this.praseException(e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void removeTargetChildListener(String path, CuratorWatcher listener) {
        ((CuratorWatcherImpl)listener).unwatch();
    }

    private void praseException(Exception e) {
        if (e instanceof KeeperException.SessionExpiredException) {
            try {
                this.startClient();
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
            }
        }
    }

    private class CuratorWatcherImpl
    implements CuratorWatcher {
        private volatile ChildListener listener;

        public CuratorWatcherImpl(ChildListener listener) {
            this.listener = listener;
        }

        public void unwatch() {
            this.listener = null;
        }

        public void process(WatchedEvent event) throws Exception {
            if (event.getType() != Watcher.Event.EventType.None && this.listener != null) {
                String path = event.getPath() == null ? "" : event.getPath();
                this.listener.childChanged(path, StringUtils.isNotEmpty((String)path) ? (List)((BackgroundPathable)CuratorZookeeperClient.this.client.getChildren().usingWatcher((CuratorWatcher)this)).forPath(path) : EMPTY_CHILDREN);
            }
        }
    }
}

